// Revision: 33 1.4.1.3 source/ui/baseapp/ifonthdr.hpp, views, ioc.v400, 980918  
#ifndef _IFONTHDR_
#define _IFONTHDR_
/*******************************************************************************
* FILE NAME: ifonthdr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IFontDialogHandler                                                       *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>
#include <ievent.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IFont;
class IFontDialog;
class IFontDialogHandlerData;

#pragma enum(4)
#pragma pack(push,4)

class IFontDialogHandler : public IHandler {
typedef IHandler
  Inherited;

public:
/*------------------------------ Constructors --------------------------------*/
  IFontDialogHandler();
virtual
  ~IFontDialogHandler();

protected:
/*---------------------------- Event Dispatching -----------------------------*/
virtual bool
  dispatchHandlerEvent(IEvent& event);

/*-------------------------- Font Dialog Dismissal ---------------------------*/
virtual bool
  modelessResults     (IFontDialog* endingDialog);

#ifndef IC_MOTIF_FLAGNOP
virtual bool
  modelessApply       (IFontDialog* modelessDialog,
                       IFont*       appliedFont );
#endif

private:
/*--------------------------------- Private ----------------------------------*/
IFontDialogHandlerData
 *fFontDialogHandlerData;
};

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* IFONTHDR */
