// Revision: 30 1.9.1.5 source/ui/baseapp/ifontdlg.hpp, views, ioc.v400, 980918 
#ifndef _IFONTDLG_
#define _IFONTDLG_
/*******************************************************************************
* FILE NAME: IFONTDLG.HPP                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IFontDialog                                                              *
*     IFontDialog::Settings                                                    *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <iframe.hpp>
#include <istring.hpp>

#ifdef IC_PM
extern "C"
{
   void* _System   _IFontDlgProc( unsigned long hwnd,
                                  unsigned long ulMsg,
                                  void*         mp1,
                                  void*         mp2 );
}
#endif
#ifdef IC_WIN
extern "C" {
   void* __stdcall _IFontDlgProc( void*         hwnd,
                                  unsigned long ulMsg,
                                  void*         mp1,
                                  void*         mp2 );
}
#endif

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IResourceId;
class IPoint;
class IFont;
class IFontHandler;
class IFontDialogData;
class IFontDialogSettingsData;
struct _FONTDLG;
struct tagCHOOSEFONTA;

#pragma enum(4)
#pragma pack(push,4)

class IFontDialog : public IFrameWindow {
typedef IFrameWindow
  Inherited;
public:
class Style;
class Settings;
/*------------------------------ Constructors --------------------------------*/
 IFontDialog(IWindow*        parent,
             IWindow*        owner,
             const Style&    style = defaultStyle() );

 IFontDialog(IWindow*        parent,
             IWindow*        owner,
             const Settings& settings,
             const Style&    style = defaultStyle() );

 IFontDialog(IWindow*        parent,
             IWindow*        owner,
             const Style&    style,
             const Settings& settings );

 IFontDialog(IWindow*        parent,
             IWindow*        owner,
             IHandler*       handler,
             const Style&    style = defaultStyle(),
             const Settings& settings = Settings(0) );

virtual
 ~IFontDialog( );

/*---------------------------------- Styles ----------------------------------*/
  INESTEDBITFLAGCLASSDEF0(Style, IFontDialog);

static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU noStyle,
  IC_IMPORTU applyButton,
  IC_IMPORTU bitmapOnly,
  IC_IMPORTU fixedWidthOnly,
  IC_IMPORTU helpButton,
  IC_IMPORTU modeless,
  IC_IMPORTU noSynthesize,
#ifndef IC_WIN_FLAGNOP
  IC_IMPORTU proportionalOnly,
  IC_IMPORTU resetButton,
#endif
  IC_IMPORTU vectorOnly;

static void
  setDefaultStyle        ( const Style& newDefault );
static Style
  defaultStyle           ( );

#ifdef IC_PMWIN
virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      bool         extendedOnly = false ) const;
#endif

class Settings  {
public:
/*------------------------------- Constructors -------------------------------*/
  Settings   ( IFont*         font = 0 );
 ~Settings   ( );

/*--------------------------- Dialog Customization ---------------------------*/
Settings
 &setTitle            ( const char*        title       ),
 &setTitle            ( const IResourceId& text        ),
 &setPreviewText      ( const char*        previewText ),
 &setPosition         ( const IPoint&      position    );

#ifndef IC_MOTIF_FLAGNOP
Settings
 &setDialogTemplate   ( const IResourceId& templateId  );
#endif

/*------------------- Setting the Presentation Space -------------------------*/
#ifndef IC_MOTIF_FLAGNOP
Settings
 &setDisplayPS        ( const IPresSpaceHandle& presSpaceHandle ),
 &setPrinterPS        ( const IPresSpaceHandle& presSpaceHandle );
#endif

/*----------- Setting Information About the Initial Font ---------------------*/
Settings
 &setFont             ( IFont*        font       );

#ifndef IC_WIN_FLAGNOP
Settings
 &setFamily           ( const char*   fontFamily ),
 &setPointSize        ( unsigned long pointSize  ),
 &setSizeList         ( const char*   sizeList   );
#endif

private:
/*------------------------------ Hidden Members ------------------------------*/
Settings    ( const Settings& settings );
Settings
 &operator= ( const Settings& settings );

/*--------------------------------- Private ----------------------------------*/
friend class IFontDialog;

#ifdef IC_PMWIN
IFont
 *fApplyFont;
#endif

#ifdef IC_PM
struct _FONTDLG
 *fData;
#endif

#ifdef IC_WIN
struct tagCHOOSEFONTA
 *fData;

IString
  fTitle,
  fPreview;

IPoint
  fPosition;

unsigned long
  dlgId,
  fSettingsChanged;
#endif  // IC_WIN

IFontDialogSettingsData
 *fSettingsData;
}; // IFontDialog::Settings


/*---------------- Setting Information About the Dialog ----------------------*/
virtual IFontDialog
 &setId                  ( unsigned long  newIdentifier );

/*---------------- Getting Information About the Dialog ----------------------*/

static const unsigned long
  IC_IMPORTU ok,
  IC_IMPORTU cancel;

virtual unsigned long
  id                     ( ) const;
unsigned long
  buttonPressedId        ( ) const;

long
  returnValue            ( ) const;

bool
  isModeless             ( ) const,
  pressedOK              ( ) const;

/*---------------- Getting Information About the Chosen Font -----------------*/
unsigned long
  pointSize             ( ) const;

#ifndef IC_WIN_FLAGNOP
IString
  fontFamily            ( ) const;

#ifndef IC_MOTIF_FLAGNOP
unsigned long
  fontWeight            ( ) const,
  fontWidth             ( ) const;
#endif

unsigned long
  emHeight              ( ) const,
  xHeight               ( ) const,
  externalLeading       ( ) const,
  nominalPointSize      ( ) const;
#endif

#ifdef IC_WIN
/*----------------------------- Color Functions ------------------------------*/
virtual IColor
  backgroundColor              ( ) const;

virtual IFontDialog
 &setBackgroundColor           ( const IColor& color );
#endif // IC_WIN

private:
/*------------------------------ Hidden Members ------------------------------*/
IFontDialog   ( const IFontDialog& fontDialog );
IFontDialog
 &operator=   ( const IFontDialog& fontDialog );

/*--------------------------------- Private ----------------------------------*/
#ifdef IC_MOTIFPM
friend void* _System
  _IFontDlgProc( unsigned long hwnd,
                 unsigned long ulMsg,
                 void*         mp1,
                 void*         mp2 );
#endif
#ifdef IC_WIN
friend void* __stdcall
  _IFontDlgProc( void*         hwnd,
                 unsigned long ulMsg,
                 void*         mp1,
                 void*         mp2 );
#endif
friend class IFont;
friend class IFontHandler;

void initialize (IWindow*        parent,
                 IWindow*        owner,
                 const Style&    style,
                 IHandler*       handler,
                 const Settings& settings);

static Style
  currentDefaultStyle;

#ifdef IC_PMWIN
IFont
 *fApplyFont;
IHandler*
  _handlerToAdd;
#endif

#ifdef IC_PM
struct _FONTDLG
 *fData;
#endif

#ifdef IC_WIN
struct tagCHOOSEFONTA
 *fData;

long
  fSRC,
  fReturnVal;

IString
  fTitle,
  fPreview;

IPoint
  fPosition;

unsigned long
  fDialogId,
  fSettingsChanged;
#endif  // IC_WIN

IFontDialogData
 *fFontDialogData;

}; // IFontDialog

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <ifontdlg.inl>

#endif // _IFONTDLG_
