// Revision: 41 1.7.1.4 source/ui/extapp/iflytext.hpp, staticctls, ioc.v400, 980918 
#ifndef _IFLYTEXT_
#define _IFLYTEXT_
/*******************************************************************************
* FILE NAME: iflytext.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IFlyText                                                                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <itextctl.hpp>
#include <irect.hpp>

#ifdef IC_PM
#include <igraph2d.hpp>
#endif

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IFlyTextData;
class IResourceId;
class IString;

#pragma enum(4)
#pragma pack(push,4)

class IFlyText : public ITextControl {
typedef ITextControl
  Inherited;

public:
/*------------------------------- Constructors -------------------------------*/
  IFlyText ( unsigned long identifier,
             IWindow*      owner      );
virtual
 ~IFlyText ( );

/*----------------------------------- Text -----------------------------------*/
#ifdef IC_MOTIF
virtual IString
  text    ( ) const;
#endif

virtual IFlyText
 &setText ( const char*        text ),
 &setText ( const IResourceId& text );

/*---------------------------- Window Positioning ----------------------------*/
virtual IFlyText
 &setRelativeWindowRect ( const IRectangle& rect );

virtual IRectangle
  relativeWindowRect    ( ) const;

/*----------------------------- Window Painting ------------------------------*/
virtual IWindow
 &hide ( );

#ifdef IC_MOTIF
virtual IFlyText
 &setForegroundColor (const IColor &color),
 &setBackgroundColor (const IColor &color);
#endif //IC_MOTIF

private:
/*----------------------------- Hidden Functions -----------------------------*/
  IFlyText  ( const IFlyText& );
IFlyText
 &operator= ( const IFlyText& );

/*--------------------------------- Private ----------------------------------*/
friend class IFlyTextPaintHandler;

static IRectangle
  fgScreen;
static bool
  fgRegistered;

IFlyTextData
 *fFlyTextData;

enum ArrowPos {
  upperRight,
  upperLeft,
  lowerRight,
  lowerLeft };
ArrowPos
  fArrowPos;
IRectangle
  fWinrc;

#ifdef IC_PM
IGraphicGroup
  fHelpArrow;
IPolygon
 *fArrow;
IPolyline
 *fBorderArrow;
#endif
}; // IFlyText

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _IFLYTEXT_
