// ----------------------------------------------------------------------------
//  FILE: ifilestr.hpp
//
//  File System streaming Interface
//
//  IFileIOStream - An iostream subclass which lets you stream to and from
//                  files represented by IFile objects.
// 
//  COPYRIGHT:
//      IBM Open Class Library
//      (C) Copyright International Business Machines Corporation 1997
//      Licensed Material - Program-Property of IBM - All Rights Reserved.
// 
// Revision:  71 1.17.1.3 source/core/filesys/ifilestr.hpp, filesystem, ioc.v400, 980918 
// ----------------------------------------------------------------------------

#ifndef _IFILESTR_
#define _IFILESTR_

#include <iostream.h>
#include <ifilesys.hpp>
#include <iustrmpl.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IFSFileBuf;

#pragma enum(4)
#pragma pack(push,4)

class IFileIOStream : public iostream 
{
public:
    IFileIOStream(  const IFile& fileToOpen,
                    int modeForMe = ios::in + ios::out,
                    int modeForOthers = 0);

    IFileIOStream(  const IHostPathName& path,
                    int modeForMe = ios::in + ios::out,
                    int modeForOthers = 0,
                    const ICompoundNameParser& = IFile::defaultParser());

    virtual ~IFileIOStream();

    void close();

    void open(  const IFile& fileToOpen,
                int modeForMe = ios::in+ios::out,
                int modeForOthers = 0);

    IFile file() const;

private:
    // Disallowed functions...
    IFileIOStream(const IFileIOStream&);
    IFileIOStream& operator=(const IFileIOStream&);

    // Private data...
      IFSFileBuf*   fBuffer;
};

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif
