//
// File system iterator classes
//
//	IDirectoryIterator		- Iterates over the contents of a directory
//	IVolumeIterator			- Iterates over all mounted volumes on the system
//	IRootDirectoryIterator	- iterator over all root directories on the system
//
//      IBM Open Class Library
//      (C) Copyright International Business Machines Corporation 1997
//      Licensed Material - Program-Property of IBM - All Rights Reserved.
//
// Revision:   69   1.15.1.3   source/core/filesys/ifileitr.hpp, filesystem, ioc.v400, 980918   

#ifndef _IFILEITR_
#define _IFILEITR_

#include <ifilesys.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IFSIterator;

#pragma pack(push,4)
#pragma enum(4)

class IDirectoryIterator 
{
public:

						IDirectoryIterator	(const IDirectory&, bool recursive = false);
						IDirectoryIterator	();
						IDirectoryIterator	(const IDirectoryIterator& copy);

	IDirectoryIterator&	operator=		  	(const IDirectoryIterator& copy);

	virtual			~IDirectoryIterator	();

	IFileSystemEntity	operator*() const;
	
	IFileSystemEntity*	operator->();

	IDirectoryIterator&	operator++();

	IDirectoryIterator	operator++(int);
	
	bool				operator== (const IDirectoryIterator& other) const;

	bool				operator!= (const IDirectoryIterator& other) const;
	
						operator bool() const;

	bool				recursive() const;

    static const IDirectoryIterator& end();

private:
    // Private functions and data
	void				advance();

	IFSIterator *		fIterator;
	IFileSystemEntity	fEntity;
	bool				fRecursive;
};


class IVolumeIterator 
{
public:
						IVolumeIterator ();
						IVolumeIterator (const IVolumeIterator& copy);

	IVolumeIterator&	operator=(const IVolumeIterator& copy);

	virtual			~IVolumeIterator ();
	
	IVolume				operator*() const;

	IVolume*			operator ->();

	IVolumeIterator&	operator++();

	IVolumeIterator		operator++(int);

	bool				operator== (const IVolumeIterator& other) const;

	bool				operator!= (const IVolumeIterator& other) const;

						operator bool() const;

    static const IVolumeIterator& end();

private:
    // Private functions and data
						IVolumeIterator(IFSIterator*);

	void				advance();

	IFSIterator *		fIterator;
	IVolume				fEntity;
};


class IRootDirectoryIterator 
{
public:
							IRootDirectoryIterator();
							IRootDirectoryIterator(const IRootDirectoryIterator& copy);

	IRootDirectoryIterator&	operator=(const IRootDirectoryIterator& copy);

	virtual					~IRootDirectoryIterator();

	IDirectory				operator*() const;

	IDirectory*				operator ->();

	IRootDirectoryIterator&	operator++();		// ++iterator

	IRootDirectoryIterator	operator++(int);	//   iterator++.
	
	bool					operator== (const IRootDirectoryIterator& other) const;

	bool					operator!= (const IRootDirectoryIterator& other) const;

							operator bool() const;

    static const IRootDirectoryIterator& end();
	
private:
    // Private functions and data
							IRootDirectoryIterator(IFSIterator*);
	void					advance();

	IFSIterator *			fIterator;
	IDirectory				fEntity;
};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <ifileitr.inl>

#endif // _IFILEITR_
