// Revision: 24 1.5.1.4 source/ui/baseapp/ifilehdr.hpp, views, ioc.v400, 980918  
#ifndef _IFILEHDR_
  #define _IFILEHDR_
/*******************************************************************************
* FILE NAME: ifilehdr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the declaration of the classes:                         *
*     IFileDialogHandler                                                       *
*     IFileDialogEvent                                                         *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <ievent.hpp>
#include <ihandler.hpp>
#include <istring.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IFileDialog;
class IFileDialogHandler;

#pragma enum(4)
#pragma pack(push,4)

class IFileDialogEvent : public IEvent {
typedef IEvent
  Inherited;

public:
/*------------------------------- Constructors -------------------------------*/
  IFileDialogEvent ( IEvent& event );
virtual
  ~IFileDialogEvent ( );

/*--------------------------- File Name Accessors ----------------------------*/
IString
  fileName         ( ) const;
unsigned long
  fileLength       ( ) const;

#ifdef IC_WIN
private:
friend class IFileDialogHandler;
IString
  fFileNameSelected;
#endif
};


class IFileDialogHandler : public IHandler {
typedef IHandler
  Inherited;

public:
/*------------------------------- Constructors -------------------------------*/
  IFileDialogHandler( );
virtual
  ~IFileDialogHandler ( );

/*---------------------------- Window Attachment -----------------------------*/
virtual IFileDialogHandler
  &handleEventsFor       ( IFileDialog* fileDialog ),
  &stopHandlingEventsFor ( IFileDialog* fileDialog );

protected:
/*----------------------------- Dispatch Events ------------------------------*/
virtual bool
  dispatchHandlerEvent ( IEvent& event );

/*---------------------------- File Dialog Events ----------------------------*/
virtual bool
#ifndef IC_WIN_FLAGNOP
  filter          ( IFileDialogEvent& event   ),
  filterName      ( const IString&    fileName,
                    IFileDialog*      dialog       ),
#endif
  validate        ( IFileDialogEvent& event   ),
  validateName    ( const IString&    fileName,
                    IFileDialog*      dialog       ),
  modelessResults ( IFileDialog*      endingDialog );
virtual bool
  modelessApply   ( IFileDialog*      modelessDialog,
                    const IString&    appliedFileName );

private:

/*------------------------------ Hidden functions ---------------------------*/
virtual IHandler
 &handleEventsFor       ( IWindow* window  ),
 &stopHandlingEventsFor ( IWindow* window  );

#ifdef IC_WIN
unsigned int
  fRegisteredOkMsg;
#endif
};

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _IFILEHDR_ */
