// Revision: 21 1.12.1.7 source/ui/baseapp/ifiledlg.hpp, views, ioc.v400, 980918 
#ifndef _IFILEDLG_
#define _IFILEDLG_
/*******************************************************************************
* FILE NAME: ifiledlg.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IFileDialog                                                              *
*     IFileDialog::Settings                                                    *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <iframe.hpp>
#include <istring.hpp>
#include <ipoint.hpp>
#ifdef IC_MOTIF
#include <iarglist.hpp>
#endif

#ifdef IC_PM
extern "C"
{
   void* _System   _IFileDlgProc( unsigned long hwnd,
                                  unsigned long ulMsg,
                                  void*         mp1,
                                  void*         mp2 );
}
#endif
#ifdef IC_WIN
extern "C" {
   void* __stdcall _IFileDlgProc( void*         hwnd,
                                  unsigned long ulMsg,
                                  void*         mp1,
                                  void*         mp2 );
}
#endif

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class StringSeq;
class IResourceId;
class IFileDialogSettingsData;
class IFileDialogData;
class IFileDialogHandler;
struct _FILEDLG;
struct _WidgetRec;
struct tagOFNA;

#pragma enum(4)
#pragma pack(push,4)

class IFileDialog : public IFrameWindow {
typedef IFrameWindow
  Inherited;
public:

class Style;
class Settings;

/*----------------------------- Constructors ---------------------------------*/

  IFileDialog(IWindow*        parent,
              IWindow*        owner,
              const Style&    style = defaultStyle() );

  IFileDialog(IWindow*        parent,
              IWindow*        owner,
              const Settings& settings,
              const Style&    style = defaultStyle() );

  IFileDialog(IWindow*        parent,
              IWindow*        owner,
              const Style&    style,
              const Settings& settings );

  IFileDialog(IWindow*        parent,
              IWindow*        owner,
              IHandler*       handler,
              const Style&    style = defaultStyle(),
              const Settings& settings = Settings() );

virtual
 ~IFileDialog( );

/*-------------------------------- Styles ------------------------------------*/
  INESTEDBITFLAGCLASSDEF0(Style, IFileDialog);

static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU noStyle,
  IC_IMPORTU modeless,
#ifndef IC_MOTIFWIN_FLAGNOP
  IC_IMPORTU applyButton,
  IC_IMPORTU includeEAS,
  IC_IMPORTU filter,
  IC_IMPORTU preload,
#endif
  IC_IMPORTU helpButton,
  IC_IMPORTU multiSelection,
  IC_IMPORTU selectableListbox;

static void
  setDefaultStyle   ( const Style&    style );
static Style
  defaultStyle      ( );

#ifdef IC_PMWIN
virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      bool         extendedOnly = false ) const;
#endif

#ifdef IC_MOTIF
virtual IArgList
  convertToArgList ( const IBitFlag& style ) const;
#endif

class Settings  {
public:
/*------------------------------ Constructors --------------------------------*/
  Settings();
 ~Settings();

/*---------------------- Dialog Customization --------------------------------*/
Settings
 &setTitle                 (const char*        newTitle ),
 &setTitle                 (const IResourceId& resId    ),
 &setOKButtonText          (const char*        newText  ),
 &setOKButtonText          (const IResourceId& resId    ),
#ifndef IC_MOTIF_FLAGNOP
 &setDialogTemplate        (const IResourceId& resId    ),
#endif
 &setPosition              (const IPoint&     position  );

IPoint
  position                 ( ) const;

IString
  title                    ( ) const,
  okButtonText             ( ) const;

bool
  isPositionSet            ( ) const,
  isDialogTemplateSet      ( ) const;

/*---------------- Setting Information About the Dialog ----------------------*/
Settings
 &setOpenDialog            ( ),
 &setSaveAsDialog          ( ),
#ifndef IC_MOTIFWIN_FLAGNOP
 &setInitialFileType       (const char* fileType    ),
#endif
#ifndef IC_MOTIF_FLAGNOP
 &setInitialDrive          (const char* drive       ),
 &addFileType              (const char* fileType ,
                            const char* filter = 0  ),
#endif
#ifndef IC_MOTIFWIN_FLAGNOP
 &addDrive                 (const char* drive       ),
#endif
 &setFileName              (const char* fileName ,
                            bool fileNameIsFilter = true);

IString
#ifndef IC_MOTIF_FLAGNOP
  initialDrive             ( ) const,
#endif
#ifndef IC_MOTIFWIN_FLAGNOP
  initialFileType          ( ) const,
#endif
  fileName                 ( ) const;

bool
  isOpenDialog             ( ) const;

private:
/*------------------------------ Hidden Members ------------------------------*/
Settings    ( const Settings& settings );
Settings
 &operator= ( const Settings& settings );

/*--------------------------------- Private ----------------------------------*/
friend class IFileDialog;

#ifndef IC_MOTIF
StringSeq
#ifndef IC_WIN
 *drives                   ( ) const,
#endif
 *fileTypes                ( ) const;
#endif

IString
  titleStr,
  OKButtonStr,
  fileNameStr,
  initialDriveStr,
  initialFileTypeStr;

IPoint
  pos;

bool
  isOpenDlg,
  isPosSet;

IFileDialogSettingsData
 *fSettingsData;
};   /* Settings */

#ifndef IC_MOTIFPM_FLAGNOP
/*---------------- Setting Information About the Dialog ----------------------*/
virtual IFileDialog
 &setId                            ( unsigned long  newIdentifier );
#endif

/*---------------- Getting Information About the Dialog ----------------------*/
bool
  isModeless                       ( ) const,
  pressedOK                        ( ) const;

static const unsigned long
  IC_IMPORTU ok,
  IC_IMPORTU cancel;

#ifndef IC_PM_FLAGNOP
virtual unsigned long
  id                               ( ) const;
#endif
unsigned long
  buttonPressedId                  ( ) const;

#ifndef IC_MOTIF_FLAGNOP
long
  returnValue                      ( ) const;
#endif


/*----------- Getting Information About the Chosen File ----------------------*/
unsigned
  selectedFileCount                ( ) const;

IString
#ifndef IC_MOTIFWIN_FLAGNOP
  saveAsEAType                     ( ) const,
#endif
  fileName                         (unsigned fileNumber = 0) const;

#ifdef IC_MOTIF
virtual IFileDialog
 &show ( bool showWindow = true );
#endif // IC_MOTIF

#ifdef IC_WIN
/*----------------------------- Color Functions ------------------------------*/
virtual IColor
  backgroundColor              ( ) const;

virtual IFileDialog
 &setBackgroundColor           ( const IColor& color );
#endif // IC_WIN

private:
/*------------------------------ Hidden Members ------------------------------*/
  IFileDialog  (const IFileDialog& fileDialog );
IFileDialog
 &operator=    (const IFileDialog& fileDialog );

/*--------------------------------- Private ----------------------------------*/
#ifdef IC_MOTIFPM
struct _FILEDLG
 *pFileDlgData;
#endif
#ifdef IC_WIN
struct tagOFNA
 *pFileDlgData;
#endif

friend class IFileDialogHandler;
#ifdef IC_PM
friend void* _System
  _IFileDlgProc( unsigned long hwnd,
                 unsigned long ulMsg,
                 void*         mp1,
                 void*         mp2 );
#endif
#ifdef IC_WIN
friend void* __stdcall
  _IFileDlgProc( void*         hwnd,
                 unsigned long ulMsg,
                 void*         mp1,
                 void*         mp2 );
#endif
#ifdef IC_MOTIF
friend void _System ifiledlgMotifCallback( _WidgetRec *w,
                                           void       *clientData,
                                           void       *callData );
#endif

void initialize (IWindow*        parent,
                 IWindow*        owner,
                 const Style&    style,
                 IHandler*       handler,
                 const Settings& settings);

static Style
  currentDefaultStyle;

IFileDialogData
 *fFileDialogData;
}; /* IFileDialog */

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <ifiledlg.inl>

#endif // _IFILEDLG_
