/**
 * This file describes the Graphics Special IBaseRootGrafPort class.
 * Class described here is IExtendedRootGrafPort.
 *
 *   IBM Open Class Library
 *   (C) Copyright International Business Machines Corporation,  1997
 *   Licensed Material - Program-Property of IBM - All Rights Reserved.
 */

// Revision: 77 1.22.1.6 source/albert/graph2d/iexgrprt.hpp, 2d, ioc.v400, 980918 

#ifndef _IEXGRPRT_
#define _IEXGRPRT_

#include <igrport.hpp>
#include <icoordsy.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push,4)

/** Defines the modes of device mapping. */
enum EDeviceMappingMode {
	kPixel,
	kLowMetric,
	kHighMetric,
	kLowEnglish,
	kHighEnglish,
	kTwips
	// kIsotropic,
	// kAnisotropic
};

/**
 * IExtendedRootGrafPort is an extended IBaseRootGrafPort.
 * IExtendedRootGrafPort is an extended IBaseRootGrafPort.
 * However, IExtendedRootGrafPort uses device coordinate which is in pixels to draw all the graphics except text which  is specified in point size only.
 * IExtendedRootGrafPort  defines the coordinate system and mapping mode of the device.
 */

class IExtendedRootGrafPort : public IBaseRootGrafPort {
public:
	virtual ~IExtendedRootGrafPort();

	/**
	 * Creates an IExtendedRootGrafPort with a handle of device context and mapping mode. The type of coordinate system will be determined by ICoordinateSystem::applicationOrientation settings.
	 */
	IExtendedRootGrafPort(
		IPresSpaceHandle deviceContextToBeAdopted,
		EDeviceMappingMode =  kPixel);

	/**
	 * Creates an IExtendedRootGrafPort with a handle of device context, type of coordinate system, and mapping mode.
	 */
	IExtendedRootGrafPort(
		IPresSpaceHandle deviceContextToBeAdopted,
		ICoordinateSystem::EOrientation,
		EDeviceMappingMode =  kPixel);

private:
friend class IRootGrafPort;

private:
	// Explicitly not implemented; disabled
	IExtendedRootGrafPort();
	IExtendedRootGrafPort(const IExtendedRootGrafPort&);
	IExtendedRootGrafPort& operator=(const IExtendedRootGrafPort& source);

  //XL : in order to make IRootGrafPort(IGrafDevice* referencedDevice);
	IExtendedRootGrafPort(IGrafDevice* referencedDevice);

};

#if ( IC_OBSOLETE <= IC_OBSOLETE_3 )
// macros for compatibility
#define EDeviceCoordinateSystem ICoordinateSystem::EOrientation
#define kLeftHand ICoordinateSystem::kOriginUpperLeft
#define kRightHand ICoordinateSystem::kOriginLowerLeft
#endif // IC_OBSOLETE


#if (IC_OBSOLETE <= IC_OBSOLETE_3)
/**
 * IRootGrafPort uses device coordinate which is in pixels to draw all the graphics except text which  is specified in point size only.
 * IRootGrafPort uses device coordinate which is in pixels to draw all the graphics except text which  is specified in point size only.
 * The coordinate system in IRootGrafPort is upperLeft only.
*/

class IRootGrafPort : public IExtendedRootGrafPort {
public:
	virtual ~IRootGrafPort();
	
 /**
 * Constructs an IRootGrafPort by adopting an IPresSpaceHandle.
 */
	IRootGrafPort(IPresSpaceHandle deviceContext);

private:
		// Explicitly not implemented; disabled
	IRootGrafPort();
	IRootGrafPort(const IRootGrafPort&);
	IRootGrafPort& operator=(const IRootGrafPort& source);

private:
	friend class IGImage;
	friend class IGraph2DTestHelper;
	friend class IInternalPrintChannel;
	friend class IMakeMetaFile;
	friend class IAswOleObject;
  friend class IExtendedRootGrafPort;
  friend class IInternalPrintChannel;
	IRootGrafPort(IGrafDevice* referencedDevice);
	
};
#endif // IC_OBSOLETE

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _IEXGRPRT_
