// ----------------------------------------------------------------------------
//  FILE: iexcfile.hpp
//
//  Exception classes used in the File System Interface
//
//      IEntityInvalid          - A file system entity is invalid
//      IEntityTypeMismatch     - Wrong type of entity
//      IVolumeOffline          - Volume is offline, ejected, etc
//      IEntityInUse            - Can't delete entity that's in use
//      IFileOperationCancelled - Operation canceled by user
//
//  COPYRIGHT:
//     IBM Open Class Library
//     (C) Copyright International Business Machines Corporation 1997
//
//     Licensed Material - Program-Property of IBM - All Rights Reserved.
//
// Revision: 68 1.16.1.3 source/core/filesys/iexcfile.hpp, filesystem, ioc.v400, 980918  
// ----------------------------------------------------------------------------

#ifndef _IEXCFILE_
#define _IEXCFILE_

#include <iexcbase.hpp>
#include <ifilesys.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

class IEntityInvalid : public IInvalidParameter 
{
public:
    IEntityInvalid(const char* text = 0);

    IEntityInvalid(const IEntityInvalid &);
    virtual ~IEntityInvalid();
    
    virtual const char* name() const;

private:
    IEntityInvalid& operator=(IEntityInvalid&);
};

class IEntityTypeMismatch : public IInvalidParameter 
{
public:
    IEntityTypeMismatch(IFileKind kind, const IFileSystemEntity &entity);

    IEntityTypeMismatch(const char* text = 0);
                        
    IEntityTypeMismatch(const IEntityTypeMismatch &);
    virtual ~IEntityTypeMismatch();

    virtual const char* name() const;

private:
    IEntityTypeMismatch& operator=(IEntityTypeMismatch&);
};


class IVolumeOffline : public IDeviceError 
{
public:
    IVolumeOffline(const char* text = 0);
    IVolumeOffline(const IVolumeOffline &);
    virtual ~IVolumeOffline();
    
    virtual const char* name() const;

private:
    IVolumeOffline& operator=(IVolumeOffline&);
};


class IEntityInUse : public IAccessError 
{
public:
    IEntityInUse(const char* text = 0);
    IEntityInUse(const IEntityInUse &);
    virtual ~IEntityInUse();
    
    virtual const char* name() const;

private:
    IEntityInUse& operator=(IEntityInUse&);
};


class IFileOperationCancelled : public IException 
{
public:
    IFileOperationCancelled(const char* text = 0);
    IFileOperationCancelled(const IFileOperationCancelled &);
    virtual ~IFileOperationCancelled();
    
    virtual const char* name() const;

private:
    IFileOperationCancelled& operator=(IFileOperationCancelled&);
};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif
