// Revision: 12 1.5.1.3 source/core/base/iexcept.hpp, exception, ioc.v400, 980918 











#ifndef _IEXCEPT_
#define _IEXCEPT_
/*----------------------------------------------------------------------------*/
/* FILE NAME: iexcept.hpp                                                     */
/*                                                                            */
/* DESCRIPTION:                                                               */
/*   Declaration of the classes                                               */
/*     IBaseErrorInfo                                                         */
/*     IGUIErrorInfo                                                          */
/*     ISystemErrorInfo                                                       */
/*     ICLibErrorInfo                                                         */
/*     IXLibErrorInfo                                                         */
/*                                                                            */
/*   This file also contains several macros and functions which can be used   */
/*   to facilitate throwing exceptions.  This includes the IASSERTPARM and    */
/*   IASSERTSTATE macros, and the IExcept__assertParameter and                */
/*   IExcept__assertState functions.                                          */
/*                                                                            */
/* COPYRIGHT:                                                                 */
/*   IBM Open Class Library                                                   */
/*   Licensed Materials - Property of IBM                                     */
/*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                 */
/*                                                                            */
/*----------------------------------------------------------------------------*/

#include <ibase.hpp>
#include <iexcbase.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push,4)

class IC_EXPORTB IBaseErrorInfo {
public:
/*------------------------------- Constructors ------------------------------ */
 IBaseErrorInfo  ( );

virtual
 ~IBaseErrorInfo ( );

/*---------------------------- Error Information -----------------------------*/
virtual
  operator const char* ( ) const = 0;

virtual const char
 *text ( ) const = 0;

virtual unsigned long
  errorId ( ) const = 0;

virtual bool
  isAvailable ( ) const = 0;

enum ExceptionType { accessError, deviceError, invalidParameter,
                     invalidRequest, outOfSystemResource, outOfWindowResource,
                     outOfMemory, resourceExhausted };

/*------------------------------ Throw Support -------------------------------*/
void
  throwError ( const IExceptionLocation&  location,
               ExceptionType              name = accessError,
               IException::Severity       severity = IException::recoverable,
               IException::ErrorCodeGroup errorGroup =
                                             IException::baseLibrary );

}; // IBaseErrorInfo

#if ( IC_OBSOLETE <= IC_OBSOLETE_3 )
#if defined(IC_MOTIFPM) || defined(IUSE_IERRORINFO)
  typedef IBaseErrorInfo IErrorInfo;
#endif
#endif

class IC_EXPORTB IGUIErrorInfo : public IBaseErrorInfo {
typedef IBaseErrorInfo
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IGUIErrorInfo ( const char* GUIFunctionName = 0 );

virtual
 ~IGUIErrorInfo ( );

/*---------------------------- Error Information -----------------------------*/
virtual
  operator const char* ( ) const;

virtual const char
 *text ( ) const;

virtual unsigned long
  errorId ( ) const;

virtual bool
  isAvailable ( ) const;

/*------------------------------ Throw Support -------------------------------*/
static void
  throwGUIError  ( const char*               functionName,
                   const IExceptionLocation& location,
                   IBaseErrorInfo::ExceptionType name = accessError,
                   IException::Severity      severity = IException::recoverable );

private:
/*----------------------------- Hidden Functions -----------------------------*/
  IGUIErrorInfo ( const IGUIErrorInfo& errorInformation );

IGUIErrorInfo
 &operator= ( const IGUIErrorInfo& errorInformation );

/*--------------------------------- Private ----------------------------------*/

  unsigned long
    ulClErrorId;







char
 *pClFuncNameText;

}; // IGUIErrorInfo

class IC_EXPORTB ISystemErrorInfo : public IBaseErrorInfo {
typedef IBaseErrorInfo
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  ISystemErrorInfo ( unsigned long systemErrorId,
                     const char* systemFunctionName = 0 );

virtual
 ~ISystemErrorInfo ( );

/*---------------------------- Error Information -----------------------------*/
virtual
  operator const char* ( ) const;

virtual const char
 *text ( ) const;

virtual unsigned long
  errorId ( ) const;

virtual bool
  isAvailable ( ) const;

/*------------------------------ Throw Support -------------------------------*/
static void
  throwSystemError ( unsigned long             systemErrorId,
                     const char*               functionName,
                     const IExceptionLocation& location,
                     IBaseErrorInfo::ExceptionType name = accessError,
                     IException::Severity      severity = IException::recoverable );

private:
  ISystemErrorInfo ( const ISystemErrorInfo& errorInformation );

ISystemErrorInfo
 &operator= ( const ISystemErrorInfo& errorInformation );

/*--------------------------------- Private ----------------------------------*/
bool
  bClError;
unsigned long
  ulClErrorId;
char
 *pClErrorText;

}; // ISystemErrorInfo

class IC_EXPORTB ICLibErrorInfo : public IBaseErrorInfo {
typedef IBaseErrorInfo
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
ICLibErrorInfo ( const char* CLibFunctionName = 0 );

virtual
 ~ICLibErrorInfo ( );

/*---------------------------- Error Information -----------------------------*/
virtual
operator const char* ( ) const;

virtual const char
 *text ( ) const;

virtual unsigned long
  errorId ( ) const;

virtual bool
  isAvailable ( ) const;

/*------------------------------ Throw Support -------------------------------*/
static void
  throwCLibError (   const char*               functionName,
                     const IExceptionLocation& location,
                     IBaseErrorInfo::ExceptionType name = accessError,
                     IException::Severity      severity = IException::recoverable );

private:
/*----------------------------- Hidden Functions -----------------------------*/
  ICLibErrorInfo ( const ICLibErrorInfo& errorInformation );

ICLibErrorInfo
 &operator= ( const ICLibErrorInfo& errorInformation );

/*--------------------------------- Private ----------------------------------*/
bool
  bClError;
unsigned long
  ulClErrno;
char
 *pClErrorText;

}; // IClibErrorInfo


















































void
 IC_EXPORTB
  IExcept__assertParameter    ( const char*               assertExpression,
                                const IExceptionLocation& location );
void
 IC_EXPORTB
  IExcept__assertState        ( const char*               assertExpression,
                                const IExceptionLocation& location );
void
 IC_EXPORTB
  IExcept__throwLibraryError  (
              unsigned long             messageId,
              const IExceptionLocation& location,
              IBaseErrorInfo::ExceptionType name =
                                            IBaseErrorInfo::invalidRequest,
              IException::Severity      severity = IException::recoverable,
              const char*               text = 0);
void
 IC_EXPORTB
  IExcept__throwError (
              unsigned long              messageId,
              const IExceptionLocation&  location,
              const char*                messageFile,
              IException::ErrorCodeGroup errorGroup,
              IBaseErrorInfo::ExceptionType  name =
                                         IBaseErrorInfo::invalidRequest,
              IException::Severity       severity = IException::recoverable,
              const char*                substitutionText = 0);

#define IASSERTPARM(test)\
    if(!(test))\
    {\
       IExcept__assertParameter(#test, IEXCEPTION_LOCATION());\
    }

#define IASSERTSTATE(test)\
    if(!(test))\
    {\
       IExcept__assertState(#test, IEXCEPTION_LOCATION());\
    }

#define ITHROWGUIERROR(func)\
    IGUIErrorInfo::throwGUIError(func, IEXCEPTION_LOCATION())

#define ITHROWGUIERROR2(func, exType, sev)\
    IGUIErrorInfo::throwGUIError(func, IEXCEPTION_LOCATION(), exType, sev)

#define ITHROWSYSTEMERROR(id, func, exType, sev)\
    ISystemErrorInfo::throwSystemError(id, func, \
                                       IEXCEPTION_LOCATION(), exType, sev)

#define ITHROWCLIBERROR(func, exType, sev)\
    ICLibErrorInfo::throwCLibError(func, IEXCEPTION_LOCATION(), exType, sev)


#define ITHROWLIBRARYERROR(id, exType, sev)\
    IExcept__throwLibraryError(id, IEXCEPTION_LOCATION(), exType, sev)

#define ITHROWLIBRARYERROR1(id, exType, sev, text)\
    IExcept__throwLibraryError(id, IEXCEPTION_LOCATION(), exType, sev, text)

#define ITHROWERROR(messageId, name, severity, messageFile, errorGroup)\
    IExcept__throwError(messageId, IEXCEPTION_LOCATION(), messageFile, \
                        errorGroup, name, severity)

#define ITHROWERROR1(messageId, name, severity, messageFile,\
                     errorGroup, substitutionText)\
    IExcept__throwError(messageId, IEXCEPTION_LOCATION(), messageFile, \
                        errorGroup, name, severity, substitutionText)

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _IEXCEPT_

