// Revision: 10 1.5.1.3 source/core/base/iexcbase.hpp, exception, ioc.v400, 980918 











#ifndef _IEXCBASE_
#define _IEXCBASE_
/*----------------------------------------------------------------------------*/
/* FILE NAME: iexcbase.hpp                                                    */
/*                                                                            */
/* DESCRIPTION:                                                               */
/*   Declaration of the classes:                                              */
/*     IExceptionLocation                                                     */
/*     IException                                                             */
/*     IAccessError                                                           */
/*     IAssertionFailure                                                      */
/*     IDeviceError                                                           */
/*     IInvalidParameter                                                      */
/*     IInvalidRequest                                                        */
/*     IResourceExhausted                                                     */
/*     IOutOfMemory                                                           */
/*     IOutOfSystemResource                                                   */
/*     IOutOfWindowResource                                                   */
/*     IDecimalDataError                                                      */
/*                                                                            */
/*   This file also contains many of the macros used to implement the         */
/*   library exception handling mechanism. This includes the IASSERT, ITHROW, */
/*   IRETHROW, IEXCEPTION_LOCATION, IEXCLASSDECLARE, IEXCLASSIMPLEMENT, and   */
/*   and INO_EXCEPTIONS_SUPPORT macros.                                       */
/*                                                                            */
/* COPYRIGHT:                                                                 */
/*   IBM Open Class Library                                                   */
/*   Licensed Materials - Property of IBM                                     */
/*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                 */
/*                                                                            */
/*----------------------------------------------------------------------------*/

#ifndef IC_IMPORTB
  #if defined(__WINDOWS__) && defined(__IMPORTLIB__)
    #define IC_IMPORTB  _Import
  #else
    #define IC_IMPORTB
  #endif
#endif

#include <imsgtext.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IExcText;

#pragma enum(4)
#pragma pack(push,4)

class IC_EXPORTB IExceptionLocation {
public:

/*------------------------------- Constructors -------------------------------*/
  IExceptionLocation ( const char*   fileName = 0,
                       const char*   functionName = 0,
                       unsigned long lineNumber = 0 );

/*-------------------------------- Attributes --------------------------------*/
const char
 *fileName     ( ) const,
 *functionName ( ) const;

unsigned long
  lineNumber ( ) const;

private:
/*--------------------------------- Private ----------------------------------*/
const char
 *pClFile,
 *pClFunction;
unsigned long
  ulClLineNo;

}; // IExceptionLocation

class IC_EXPORTB IException {
public:

enum Severity { unrecoverable, recoverable };

/*------------------------------- Constructors -------------------------------*/
  IException ( const char*       errorText,
               unsigned long     errorId = 0,
               Severity          severity = IException::unrecoverable );
  IException ( const IException& exception );

virtual
 ~IException ( );

class IC_EXPORTB TraceFn {
public:
/*--------------------------------- Tracing ----------------------------------*/
virtual void
  write   ( const char* buffer ),
  logData ( IException& exception );

protected:
/*-------------------------- Protected Constructors --------------------------*/
  TraceFn ( );

/*--------------------------------- Tracing ----------------------------------*/
virtual void
  exceptionLogged ( );

}; // TraceFn

/*---------------------------- Error Code Groups -----------------------------*/
typedef const char* ErrorCodeGroup;

static ErrorCodeGroup const
  IC_IMPORTB baseLibrary,
  IC_IMPORTB CLibrary,
  IC_IMPORTB operatingSystem,
  IC_IMPORTB presentationSystem,
  IC_IMPORTB other;

IException&
  setErrorCodeGroup ( ErrorCodeGroup errorGroup );

ErrorCodeGroup
  errorCodeGroup ( ) const;

/*------------------------------ Exception Text ------------------------------*/
IException
 &appendText  ( const char*   errorText ),
 &setText     ( const char*   errorText );

const char
 *text ( unsigned long indexFromTop = 0 ) const;

unsigned long
  textCount     ( ) const;

/*---------------------------- Exception Severity ----------------------------*/
IException
 &setSeverity ( Severity      severity );

virtual int
 isRecoverable ( ) const;

/*----------------------------- Error Identifier -----------------------------*/
IException
 &setErrorId  ( unsigned long errorId );

unsigned long
  errorId       ( ) const;

/*---------------------------- Exception Location ----------------------------*/
virtual IException
 &addLocation      ( const IExceptionLocation& location );

unsigned long
  locationCount ( ) const;

const IExceptionLocation
 *locationAtIndex ( unsigned long locationIndex ) const;

/*------------------------------ Exception Type ------------------------------*/
virtual const char
 *name ( ) const;

/*---------------------------- Exception Logging -----------------------------*/
static IException::TraceFn
  *setTraceFunction ( IException::TraceFn& traceFunction );

virtual IException
 &logExceptionData ( );

/*------------------------- Application Termination --------------------------*/
virtual void
  terminate ( );

/*------------------------------ Throw Support -------------------------------*/
static void
  assertParameter ( const char*        exceptionText,
                    IExceptionLocation location );

private:
/*----------------------------- Hidden Functions -----------------------------*/
IException
 &operator= ( const IException& exc );

/*--------------------------------- Private ----------------------------------*/
friend class IC_EXPORTB IException::TraceFn;

Severity
  exsevCl;
unsigned long
  ulClErrorId;
IExceptionLocation
  exlocClArray[5];
unsigned long
  ulexlocClCount,
  ulClTxtLvlCount;
IExcText
 *msgtxtClTop;
ErrorCodeGroup
  fErrorGroup;

}; // IException

#if !defined( INO_EXCEPTIONS_SUPPORT )
  #define INO_EXCEPTIONS_SUPPORT 0
#endif






#if defined ( __FUNCTION__ )
  #define IEXCEPTION_LOCATION()  \
                IExceptionLocation(__FILE__, __FUNCTION__, __LINE__)
#else
  #define IEXCEPTION_LOCATION()   \
                IExceptionLocation(__FILE__, 0, __LINE__)
#endif

#if (INO_EXCEPTIONS_SUPPORT)
  #define ITHROW(exc)\
     exc.addLocation(IEXCEPTION_LOCATION()),\
     exc.logExceptionData(),\
     exc.terminate()
#else
  #define ITHROW(exc)\
     exc.addLocation(IEXCEPTION_LOCATION()),\
     exc.logExceptionData(),\
     throw(exc)
#endif

#define IRETHROW(exc)\
     exc.addLocation(IEXCEPTION_LOCATION()),\
     exc.logExceptionData(),\
     throw

#if defined(IC_DEVELOP)
  #define IASSERT(test)\
      if(!(test))\
      {\
         IException::assertParameter(   \
   "The following expression must be true, but evaluated to false: " #test,\
         IEXCEPTION_LOCATION());\
      }
#else
  #define IASSERT(test)
#endif

#define IEXCLASSDECLARE(child,parent) class IC_EXPORTB child : \
                                                       public parent { \
public:\
  child(const char* a, unsigned long b = 0,\
        Severity c = IException::unrecoverable);\
  virtual const char* name() const;\
  virtual ~child();\
  child(const child &);\
private:\
  child &operator = ( const child & );\
}

#define IEXCLASSIMPLEMENT(child,parent)\
  child :: child(const char* a, unsigned long b,\
                 Severity c)\
    : parent(a, b, c)\
        { }\
  const char* child :: name() const\
    {\
     return ( # child);\
    }\
  child :: ~child() {;}\
  child :: child(const child & a) : parent(a) {;}

IEXCLASSDECLARE(IAccessError,IException);
IEXCLASSDECLARE(IAssertionFailure,IException);
IEXCLASSDECLARE(IDeviceError,IException);
IEXCLASSDECLARE(IInvalidParameter,IException);
IEXCLASSDECLARE(IInvalidRequest,IException);
IEXCLASSDECLARE(IResourceExhausted,IException);
  IEXCLASSDECLARE(IOutOfMemory,IResourceExhausted);
  IEXCLASSDECLARE(IOutOfSystemResource,IResourceExhausted);
  IEXCLASSDECLARE(IOutOfWindowResource,IResourceExhausted);
  IEXCLASSDECLARE(IDecimalDataError,IException);

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <ibasepl.hpp>

#endif // _IEXCBASE_


