// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 45 1.5.1.3 source/core/collect/iexc.h, collection, ioc.v400, 980918 
#ifndef _IEXC_
#define _IEXC_

#include <iiglobal.h>
#include <iexcbase.hpp>
#include <iexctxt.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)

















#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)


class IC_EXPORTC ICollectionResourceException : public IException 
{
public:

           ICollectionResourceException
                            (char const*, unsigned long = 0,
                             Severity = IException::unrecoverable);

           ICollectionResourceException
                            (ICollectionResourceException const&);

  virtual  ~ICollectionResourceException
                            ();

  virtual  char const* name () const;

  static
  void     throwIt          (unsigned long,
                             char const*, unsigned long);

protected:

private:

        void     operator=        (ICollectionResourceException const&);











};

class IC_EXPORTC ICollectionLockException : public IException 
{
public:

           ICollectionLockException
                            (char const*, unsigned long = 0,
                             Severity = IException::unrecoverable);

           ICollectionLockException
                            (ICollectionLockException const&);

  virtual  ~ICollectionLockException
                            ();

  virtual  char const* name () const;

  static
  void     throwIt          (unsigned long,
                             char const*, unsigned long);

protected:

private:

        void     operator=        (ICollectionLockException const&);











};

class IC_EXPORTC ICollectionLockTimeOutException : public IException 
{
public:

           ICollectionLockTimeOutException
                            (char const*, unsigned long = 0,
                             Severity = IException::unrecoverable);

           ICollectionLockTimeOutException
                            (ICollectionLockTimeOutException const&);

  virtual  ~ICollectionLockTimeOutException
                            ();

  virtual  char const* name () const;

  static
  void     throwIt          (unsigned long,
                             char const*, unsigned long);

protected:

private:

        void     operator=        (ICollectionLockTimeOutException const&);











};

class IC_EXPORTC ICollectionUnlockException : public IException 
{
public:

           ICollectionUnlockException
                            (char const*, unsigned long = 0,
                             Severity = IException::unrecoverable);

           ICollectionUnlockException
                            (ICollectionUnlockException const&);

  virtual  ~ICollectionUnlockException
                            ();

  virtual  char const* name () const;

  static
  void     throwIt          (unsigned long,
                             char const*, unsigned long);

protected:

private:

        void     operator=        (ICollectionUnlockException const&);











};


class IC_EXPORTC IPreconditionViolation : public IException 
{
public:

           IPreconditionViolation
                            (char const*, unsigned long = 0,
                             Severity = IException::unrecoverable);

           IPreconditionViolation
                            (IPreconditionViolation const&);

  virtual ~IPreconditionViolation
                            ();

  virtual
  char const*
           name             () const;

  static
  void     throwIt          (unsigned long,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (IPreconditionViolation const&);












};

class IC_EXPORTC IFullException : public IPreconditionViolation 
{
public:

           IFullException   (char const*, unsigned long = 0,
                             Severity = IException::unrecoverable);

           IFullException   (IFullException const&);

  virtual ~IFullException   ();

  virtual
  char const*
           name             () const;

  static
  void     throwIt          (unsigned long,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (IFullException const&);











};

class IC_EXPORTC IEmptyException : public IPreconditionViolation {
public:

           IEmptyException  (char const*, unsigned long = 0,
                             Severity = IException::unrecoverable);

           IEmptyException  (IEmptyException const&);

  virtual ~IEmptyException  ();

  virtual
  char const*
           name             () const;

  static
  void     throwIt          (unsigned long,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (IEmptyException const&);












};

class IC_EXPORTC INotEmptyException : public IPreconditionViolation 
{
public:

           INotEmptyException
                            (char const*, unsigned long = 0,
                             Severity = IException::unrecoverable);

           INotEmptyException
                            (INotEmptyException const&);

  virtual ~INotEmptyException
                            ();

  virtual
  char const*
           name             () const;

  static
  void     throwIt          (unsigned long,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (INotEmptyException const&);












};

class IC_EXPORTC INotBoundedException : public IPreconditionViolation 
{
public:

           INotBoundedException
                            (char const*, unsigned long = 0,
                             Severity = IException::unrecoverable);

           INotBoundedException
                            (INotBoundedException const&);

  virtual ~INotBoundedException
                            ();

  virtual
  char const*
           name             () const;

  static
  void     throwIt          (unsigned long,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (INotBoundedException const&);












};

class IC_EXPORTC ICursorInvalidException : public IPreconditionViolation 
{
public:

           ICursorInvalidException
                            (char const*, unsigned long = 0,
                             Severity = IException::unrecoverable);

           ICursorInvalidException
                            (ICursorInvalidException const&);

  virtual ~ICursorInvalidException
                            ();

  virtual
  char const*
           name             () const;

  static
  void     throwIt          (unsigned long,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (ICursorInvalidException const&);












};

class IC_EXPORTC IPositionInvalidException : public IPreconditionViolation 
{
public:

           IPositionInvalidException
                            (char const*, unsigned long = 0,
                             Severity = IException::unrecoverable);

           IPositionInvalidException
                            (IPositionInvalidException const&);

  virtual ~IPositionInvalidException
                            ();

  virtual
  char const*
           name             () const;

  static
  void     throwIt          (unsigned long,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (IPositionInvalidException const&);












};

class IC_EXPORTC INotContainsKeyException : public IPreconditionViolation 
{
public:

           INotContainsKeyException
                            (char const*, unsigned long = 0,
                             Severity = IException::unrecoverable);

           INotContainsKeyException
                            (INotContainsKeyException const&);

  virtual ~INotContainsKeyException
                            ();

  virtual
  char const*
           name             () const;

  static
  void     throwIt          (unsigned long,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (INotContainsKeyException const&);












};

class IC_EXPORTC IKeyAlreadyExistsException : public IPreconditionViolation 
{
public:

           IKeyAlreadyExistsException
                            (char const*, unsigned long = 0,
                             Severity = IException::unrecoverable);

           IKeyAlreadyExistsException
                            (IKeyAlreadyExistsException const&);

  virtual ~IKeyAlreadyExistsException
                            ();

  virtual
  char const*
           name             () const;

  static
  void     throwIt          (unsigned long,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (IKeyAlreadyExistsException const&);












};

class IC_EXPORTC IRootAlreadyExistsException : public IPreconditionViolation 
{
public:

           IRootAlreadyExistsException
                            (char const*, unsigned long = 0,
                             Severity = IException::unrecoverable);

           IRootAlreadyExistsException
                            (IRootAlreadyExistsException const&);

  virtual ~IRootAlreadyExistsException
                            ();

  virtual
  char const*
           name             () const;

  static
  void     throwIt          (unsigned long,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (IRootAlreadyExistsException const&);












};

class IC_EXPORTC IChildAlreadyExistsException : public IPreconditionViolation 
{
public:

           IChildAlreadyExistsException
                            (char const*, unsigned long = 0,
                             Severity = IException::unrecoverable);

           IChildAlreadyExistsException
                            (IChildAlreadyExistsException const&);

  virtual ~IChildAlreadyExistsException
                            ();

  virtual
  char const*
           name             () const;

  static
  void     throwIt          (unsigned long,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (IChildAlreadyExistsException const&);












};

class IC_EXPORTC IIdenticalCollectionException : public IPreconditionViolation 
{
public:

           IIdenticalCollectionException
                            (char const*, unsigned long = 0,
                             Severity = IException::unrecoverable);

           IIdenticalCollectionException
                            (IIdenticalCollectionException const&);

  virtual ~IIdenticalCollectionException
                            ();

  virtual
  char const*
           name             () const;

  static
  void     throwIt          (unsigned long,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (IIdenticalCollectionException const&);












};

class IC_EXPORTC IInvalidReplacementException : public IPreconditionViolation 
{
public:

           IInvalidReplacementException
                            (char const*, unsigned long = 0,
                             Severity = IException::unrecoverable);

           IInvalidReplacementException
                            (IInvalidReplacementException const&);

  virtual ~IInvalidReplacementException
                            ();

  virtual
  char const*
           name             () const;

  static
  void     throwIt          (unsigned long,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (IInvalidReplacementException const&);












};

class IC_EXPORTC ICyclicAttachException : public IPreconditionViolation 
{
public:

           ICyclicAttachException
                            (char const*, unsigned long = 0,
                             Severity = IException::unrecoverable);

           ICyclicAttachException
                            (ICyclicAttachException const&);

  virtual ~ICyclicAttachException
                            ();

  virtual
  char const*
           name             () const;

  static
  void     throwIt          (unsigned long,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (ICyclicAttachException const&);












};

class IC_EXPORTC IOutOfCollectionMemory : public IOutOfMemory 
{
public:

           IOutOfCollectionMemory
                            (char const*, unsigned long = 0,
                             Severity = IException::unrecoverable);

           IOutOfCollectionMemory
                            (IOutOfCollectionMemory const&);

  virtual ~IOutOfCollectionMemory
                            ();

  virtual
  char const*
           name             () const;

  static
  void     throwIt          (unsigned long,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (IOutOfCollectionMemory const&);












};


















































































































































































































#if ! defined(__INO_STREAMING__)
class IC_EXPORTC IStreamErrorException : public IException 
{
public:

           IStreamErrorException
                            (char const*, unsigned long = 0,
                            Severity = IException::unrecoverable);

           IStreamErrorException
                            (IStreamErrorException const&);

  virtual  ~IStreamErrorException
                            ();

  virtual  char const* name () const;

  static
  void     throwIt          (unsigned long,
                             char const*, unsigned long);

protected:

private:

        void     operator=        (IStreamErrorException const&);











};

class IC_EXPORTC IStreamerInvalidException : public IException 
{
public:

           IStreamerInvalidException
                            (char const*, unsigned long = 0,
                            Severity = IException::unrecoverable);

           IStreamerInvalidException
                            (IStreamerInvalidException const&);

  virtual  ~IStreamerInvalidException
                            ();

  virtual  char const* name () const;

  static
  void     throwIt          (unsigned long,
                             char const*, unsigned long);

protected:

private:

        void     operator=        (IStreamerInvalidException const&);











};
#endif

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif













#pragma info (restore)


#endif // _IEXC_
