// Revision: 14 1.8.1.3 source/ui/baseapp/ievent.hpp, basewin, ioc.v400, 980918  
#ifndef _IEVENT_
#define _IEVENT_
/*******************************************************************************
* FILE NAME: ievent.hpp                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IEvent                                                                   *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>
#include <ievtdata.hpp>
#include <ihandle.hpp>
#include <iuipl.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IEventPrivateData;
class IWindow;
class IHandlerList;

#pragma enum(4)
#pragma pack(push,4)

class IEvent  {
public:
/*------------------------------- Constructors -------------------------------*/
  IEvent    ( const IWindowHandle&    handle,
              unsigned long           eventId,
              const IEventParameter1& parameter1,
              const IEventParameter2& parameter2 );

  IEvent    ( IWindow*                window,
              unsigned long           eventId,
              const IEventParameter1& parameter1,
              const IEventParameter2& parameter2 );

  IEvent    ( const IEvent&           event );

IEvent
 &operator= ( const IEvent&           event );

virtual
 ~IEvent    ( );

/*-------------------------------- Event Data --------------------------------*/
unsigned long
  eventId    ( ) const;

IEventParameter1
  parameter1 ( ) const;

IEventParameter2
  parameter2 ( ) const;

IEventResult
  result     ( ) const;

IEvent
 &setResult  ( const IEventResult& eventResult ),
 &setResult  ( bool             eventResult );

#ifdef IC_MOTIFWIN
bool
  passToOwner    ( ) const;

IEvent
 &setPassToOwner ( bool   passOn = true ),
 &setNumberOfLevels( int levels = -1 ),
 &decrementOwnerLevels();
#endif //IC_MOTIFWIN

/*------------------------------- Event Window -------------------------------*/
virtual IWindow
 *window               ( ) const,
 *dispatchingWindow    ( ) const,
 *controlWindow        ( ) const;

IWindowHandle
  handle               ( ) const,
  controlHandle        ( ) const;

IEvent
 &setHandle            ( const IWindowHandle& handle ),
 &setDispatchingHandle ( const IWindowHandle& handle ),
 &setDispatchingWindow ( IWindow* window ),
 &setControlHandle     ( const IWindowHandle& handle );

private:
/*--------------------------------- Private ----------------------------------*/
friend class IWindow;

IEvent
  &setHandlerCursor(void* cursor),
  &setHandlerList(IHandlerList* handlerList);

void
  *handlerCursor() const;

IHandlerList
  *handlerList() const;

IWindowHandle
  hCl,
  p_controlHandle;
IWindow
  *fdispatchingWindow;
unsigned long
  ulClEvtId;
IEventData
  epCl1,
  epCl2;
IEventResult
  erCl;
void
  *fCursor;
IHandlerList
  *fHandlerList;
IEventPrivateData
  *pData;
#ifdef IC_MOTIFWIN
bool
  dispatchToOwner;
int
  fOwnerLevels;
#endif //IC_MOTIFWIN
}; // IEvent

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <ievent.inl>

#endif /* _IEVENT_ */
