// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 42 1.5.1.4 source/core/collect/iestab.h, collection, ioc.v400, 980918 
#ifndef _IESTAB_
#define _IESTAB_

#include <ilanglvl.hpp>
#include <iaes.h>
#include <iices.h>

#include <iives.h>

#include <iiestab.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGEqualitySequenceAsTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGEqualitySequenceAsTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGEqualitySequenceAsTable
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGEqualitySequenceAsTableCursor
                            (IGEqualitySequenceAsTable
                              <
                               Element, ElementOps> const&);

  IGEqualitySequenceAsTableCursor <Element, ElementOps>&
           operator=        (IGEqualitySequenceAsTableCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGEqualitySequenceAsTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGEqualitySequenceAsTable :
  public IAEqualitySequence <Element> {
protected:

  typedef  IGEqualitySequenceAsTable <Element, ElementOps> Self;

  typedef  IEqualitySequenceAsTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICEqualitySequenceImpl
            <PureImplementation> Implementation;
#endif

#define IGEqualitySequenceAsTableTypedef(Element, ElementOps)\
  typedef  IEqualitySequenceAsTableOps\
            <Element,\
             IWEOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGEqualitySequenceAsTableTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGEqualitySequenceAsTableCursor
            <Element, ElementOps> Cursor;




           IGEqualitySequenceAsTable
                            (INumber = 100);

           IGEqualitySequenceAsTable
                            (IGEqualitySequenceAsTable
                              <
                               Element, ElementOps> const&);

  IGEqualitySequenceAsTable <Element, ElementOps>&
           operator=        (IGEqualitySequenceAsTable
                              <
                               Element, ElementOps> const&);



















protected:

           IGEqualitySequenceAsTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGEqualitySequenceAsTable
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGEqualitySequenceAsTableCursor <Element, ElementOps>;






















};

template <class Element>
class IEqualitySequenceAsTable :
  public IGEqualitySequenceAsTable
          <Element, IEOps <Element> > {

  typedef  IGEqualitySequenceAsTable
            <Element,
             IEOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IEqualitySequenceAsTable <Element> Self;

#define IEqualitySequenceAsTableTypedef(Element)\
  typedef  IEqualitySequenceAsTableOps\
            <Element,\
             IWEOps <Element, IEOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IEqualitySequenceAsTable
                            (INumber = 100);

















protected:

           IEqualitySequenceAsTable
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGEqualitySequenceAsTable :
  public IGEqualitySequenceAsTable
          <Element, ElementOps > {

  typedef  IVGEqualitySequenceAsTable
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGEqualitySequenceAsTable
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVEqualitySequenceImpl
            <PureImplementation> Implementation;
#else
  typedef  ICEqualitySequenceImpl
            <IVEqualitySequenceImpl
              <PureImplementation> > Implementation;
#endif

#define IVGEqualitySequenceAsTableTypedef(Element, ElementOps)\
  typedef  IEqualitySequenceAsTableOps\
            <Element,\
             IWEOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGEqualitySequenceAsTableTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGEqualitySequenceAsTable
                            (INumber = 100);

















protected:

           IVGEqualitySequenceAsTable
                              (PureImplementation&);

private:












};

template <class Element>
class IVEqualitySequenceAsTable :
  public IVGEqualitySequenceAsTable
          <Element, IEOps <Element> > {

  typedef  IVGEqualitySequenceAsTable
            <Element,
             IEOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVEqualitySequenceAsTable <Element> Self;

#define IVEqualitySequenceAsTableTypedef(Element)\
  typedef  IVEqualitySequenceAsTableOps\
            <Element,\
             IWEOps <Element, IEOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVEqualitySequenceAsTable
                            (INumber = 100);

















protected:

           IVEqualitySequenceAsTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iestab.inl>


#pragma info (restore)


#endif // _IESTAB_
