// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 40 1.5.1.4 source/core/collect/ieslst.h, collection, ioc.v400, 980918 
#ifndef _IESLST_
#define _IESLST_

#include <ilanglvl.hpp>
#include <iaes.h>
#include <iices.h>

#include <iives.h>

#include <iieslst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGEqualitySequenceAsList;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGEqualitySequenceAsListCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGEqualitySequenceAsList
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGEqualitySequenceAsListCursor
                            (IGEqualitySequenceAsList
                              <
                               Element, ElementOps> const&);

  IGEqualitySequenceAsListCursor <Element, ElementOps>&
           operator=        (IGEqualitySequenceAsListCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGEqualitySequenceAsListCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGEqualitySequenceAsList :
  public IAEqualitySequence <Element> {
protected:

  typedef  IGEqualitySequenceAsList <Element, ElementOps> Self;

  typedef  IEqualitySequenceAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICEqualitySequenceImpl
            <PureImplementation> Implementation;
#endif

#define IGEqualitySequenceAsListTypedef(Element, ElementOps)\
  typedef  IEqualitySequenceAsListOps\
            <Element,\
             IWEOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGEqualitySequenceAsListTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGEqualitySequenceAsListCursor
            <Element, ElementOps> Cursor;




           IGEqualitySequenceAsList
                            (INumber = 100);

           IGEqualitySequenceAsList
                            (IGEqualitySequenceAsList
                              <
                               Element, ElementOps> const&);

  IGEqualitySequenceAsList <Element, ElementOps>&
           operator=        (IGEqualitySequenceAsList
                              <
                               Element, ElementOps> const&);



















protected:

           IGEqualitySequenceAsList
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGEqualitySequenceAsList
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGEqualitySequenceAsListCursor <Element, ElementOps>;






















};

template <class Element>
class IEqualitySequenceAsList :
  public IGEqualitySequenceAsList
          <Element, IEOps <Element> > {

  typedef  IGEqualitySequenceAsList
            <Element,
             IEOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IEqualitySequenceAsList <Element> Self;

#define IEqualitySequenceAsListTypedef(Element)\
  typedef  IEqualitySequenceAsListOps\
            <Element,\
             IWEOps <Element, IEOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IEqualitySequenceAsList
                            (INumber = 100);

















protected:

           IEqualitySequenceAsList
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGEqualitySequenceAsList :
  public IGEqualitySequenceAsList
          <Element, ElementOps > {

  typedef  IVGEqualitySequenceAsList
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGEqualitySequenceAsList
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVEqualitySequenceImpl
            <PureImplementation> Implementation;
#else
  typedef  ICEqualitySequenceImpl
            <IVEqualitySequenceImpl
              <PureImplementation> > Implementation;
#endif

#define IVGEqualitySequenceAsListTypedef(Element, ElementOps)\
  typedef  IEqualitySequenceAsListOps\
            <Element,\
             IWEOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGEqualitySequenceAsListTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGEqualitySequenceAsList
                            (INumber = 100);

















protected:

           IVGEqualitySequenceAsList
                              (PureImplementation&);

private:












};

template <class Element>
class IVEqualitySequenceAsList :
  public IVGEqualitySequenceAsList
          <Element, IEOps <Element> > {

  typedef  IVGEqualitySequenceAsList
            <Element,
             IEOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVEqualitySequenceAsList <Element> Self;

#define IVEqualitySequenceAsListTypedef(Element)\
  typedef  IVEqualitySequenceAsListOps\
            <Element,\
             IWEOps <Element, IEOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVEqualitySequenceAsList
                            (INumber = 100);

















protected:

           IVEqualitySequenceAsList
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <ieslst.inl>


#pragma info (restore)


#endif // _IESLST_
