// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 38 1.5.1.4 source/core/collect/iesdil.h, collection, ioc.v400, 980918 
#ifndef _IESDIL_
#define _IESDIL_

#include <ilanglvl.hpp>
#include <iaes.h>
#include <iices.h>

#include <iives.h>

#include <iiesdil.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGEqualitySequenceAsDilTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGEqualitySequenceAsDilTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGEqualitySequenceAsDilTable
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGEqualitySequenceAsDilTableCursor
                            (IGEqualitySequenceAsDilTable
                              <
                               Element, ElementOps> const&);

  IGEqualitySequenceAsDilTableCursor <Element, ElementOps>&
           operator=        (IGEqualitySequenceAsDilTableCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGEqualitySequenceAsDilTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGEqualitySequenceAsDilTable :
  public IAEqualitySequence <Element> {
protected:

  typedef  IGEqualitySequenceAsDilTable <Element, ElementOps> Self;

  typedef  IEqualitySequenceAsDilTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICEqualitySequenceImpl
            <PureImplementation> Implementation;
#endif

#define IGEqualitySequenceAsDilTableTypedef(Element, ElementOps)\
  typedef  IEqualitySequenceAsDilTableOps\
            <Element,\
             IWEOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGEqualitySequenceAsDilTableTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGEqualitySequenceAsDilTableCursor
            <Element, ElementOps> Cursor;




           IGEqualitySequenceAsDilTable
                            (INumber = 100);

           IGEqualitySequenceAsDilTable
                            (IGEqualitySequenceAsDilTable
                              <
                               Element, ElementOps> const&);

  IGEqualitySequenceAsDilTable <Element, ElementOps>&
           operator=        (IGEqualitySequenceAsDilTable
                              <
                               Element, ElementOps> const&);



















protected:

           IGEqualitySequenceAsDilTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGEqualitySequenceAsDilTable
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGEqualitySequenceAsDilTableCursor <Element, ElementOps>;






















};

template <class Element>
class IEqualitySequenceAsDilTable :
  public IGEqualitySequenceAsDilTable
          <Element, IEOps <Element> > {

  typedef  IGEqualitySequenceAsDilTable
            <Element,
             IEOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IEqualitySequenceAsDilTable <Element> Self;

#define IEqualitySequenceAsDilTableTypedef(Element)\
  typedef  IEqualitySequenceAsDilTableOps\
            <Element,\
             IWEOps <Element, IEOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IEqualitySequenceAsDilTable
                            (INumber = 100);

















protected:

           IEqualitySequenceAsDilTable
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGEqualitySequenceAsDilTable :
  public IGEqualitySequenceAsDilTable
          <Element, ElementOps > {

  typedef  IVGEqualitySequenceAsDilTable
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGEqualitySequenceAsDilTable
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVEqualitySequenceImpl
            <PureImplementation> Implementation;
#else
  typedef  ICEqualitySequenceImpl
            <IVEqualitySequenceImpl
              <PureImplementation> > Implementation;
#endif

#define IVGEqualitySequenceAsDilTableTypedef(Element, ElementOps)\
  typedef  IEqualitySequenceAsDilTableOps\
            <Element,\
             IWEOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGEqualitySequenceAsDilTableTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGEqualitySequenceAsDilTable
                            (INumber = 100);

















protected:

           IVGEqualitySequenceAsDilTable
                              (PureImplementation&);

private:












};

template <class Element>
class IVEqualitySequenceAsDilTable :
  public IVGEqualitySequenceAsDilTable
          <Element, IEOps <Element> > {

  typedef  IVGEqualitySequenceAsDilTable
            <Element,
             IEOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVEqualitySequenceAsDilTable <Element> Self;

#define IVEqualitySequenceAsDilTableTypedef(Element)\
  typedef  IVEqualitySequenceAsDilTableOps\
            <Element,\
             IWEOps <Element, IEOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVEqualitySequenceAsDilTable
                            (INumber = 100);

















protected:

           IVEqualitySequenceAsDilTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iesdil.inl>


#pragma info (restore)


#endif // _IESDIL_
