// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 36 1.6.1.4 source/core/collect/ies.h, collection, ioc.v400, 980918 
#ifndef _IES_
#define _IES_

#include <ilanglvl.hpp>
#include <iaes.h>
#include <iices.h>

#include <iives.h>

#include <iieslst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGEqualitySequence;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGEqualitySequenceCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGEqualitySequence
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGEqualitySequenceCursor
                            (IGEqualitySequence
                              <
                               Element, ElementOps> const&);

  IGEqualitySequenceCursor <Element, ElementOps>&
           operator=        (IGEqualitySequenceCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGEqualitySequenceCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGEqualitySequence :
  public IAEqualitySequence <Element> {
protected:

  typedef  IGEqualitySequence <Element, ElementOps> Self;

  typedef  IEqualitySequenceAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICEqualitySequenceImpl
            <PureImplementation> Implementation;
#endif

#define IGEqualitySequenceTypedef(Element, ElementOps)\
  typedef  IEqualitySequenceAsListOps\
            <Element,\
             IWEOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGEqualitySequenceTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGEqualitySequenceCursor
            <Element, ElementOps> Cursor;




           IGEqualitySequence
                            (INumber = 100);

           IGEqualitySequence
                            (IGEqualitySequence
                              <
                               Element, ElementOps> const&);

  IGEqualitySequence <Element, ElementOps>&
           operator=        (IGEqualitySequence
                              <
                               Element, ElementOps> const&);



















protected:

           IGEqualitySequence
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGEqualitySequence
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGEqualitySequenceCursor <Element, ElementOps>;






















};

template <class Element>
class IEqualitySequence :
  public IGEqualitySequence
          <Element, IEOps <Element> > {

  typedef  IGEqualitySequence
            <Element,
             IEOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IEqualitySequence <Element> Self;

#define IEqualitySequenceTypedef(Element)\
  typedef  IEqualitySequenceAsListOps\
            <Element,\
             IWEOps <Element, IEOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IEqualitySequence
                            (INumber = 100);

















protected:

           IEqualitySequence
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGEqualitySequence :
  public IGEqualitySequence
          <Element, ElementOps > {

  typedef  IVGEqualitySequence
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGEqualitySequence
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVEqualitySequenceImpl
            <PureImplementation> Implementation;
#else
  typedef  ICEqualitySequenceImpl
            <IVEqualitySequenceImpl
              <PureImplementation> > Implementation;
#endif

#define IVGEqualitySequenceTypedef(Element, ElementOps)\
  typedef  IEqualitySequenceAsListOps\
            <Element,\
             IWEOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGEqualitySequenceTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGEqualitySequence
                            (INumber = 100);

















protected:

           IVGEqualitySequence
                              (PureImplementation&);

private:












};

template <class Element>
class IVEqualitySequence :
  public IVGEqualitySequence
          <Element, IEOps <Element> > {

  typedef  IVGEqualitySequence
            <Element,
             IEOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVEqualitySequence <Element> Self;

#define IVEqualitySequenceTypedef(Element)\
  typedef  IVEqualitySequenceAsListOps\
            <Element,\
             IWEOps <Element, IEOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVEqualitySequence
                            (INumber = 100);

















protected:

           IVEqualitySequence
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <ies.inl>


#pragma info (restore)


#endif // _IES_
