// Revision: 67 1.12 source/ui/basectl/idrawcv.hpp, canvas, ioc.v400, 980918 
#ifndef _IDRAWCV_
#define _IDRAWCV_
/*******************************************************************************
* FILE NAME: idrawcv.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDrawingCanvas                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <icanvas.hpp>
#include <irect.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IGraphicGroup;
class IGrafPort;
class IPoint;
class IDrawingCanvasData;

#ifdef IC_PMWIN
#if ( IC_OBSOLETE <= IC_OBSOLETE_3 )
class IGList;
class IGraphicContext;
class IDrawingCanvas;
class IPaintEvent;
typedef ISize ( *PTROldCalcMinimumSize)( const IDrawingCanvas*, const ISize& );
typedef bool  ( *PTROldPaintWindow)    ( IDrawingCanvas*, IPaintEvent& );
#endif // IC_OBSOLETE
#endif // IC_PMWIN

#pragma enum(4)
#pragma pack(push,4)

class IDrawingCanvas : public ICanvas {
typedef ICanvas
  Inherited;

public:
class Style;
/*------------------------------- Constructors -------------------------------*/
  IDrawingCanvas( unsigned long      windowIdentifier,
                  IWindow*           parent,
                  IWindow*           owner,
                  const IRectangle&  initial = IRectangle(),
                  const Style&       style = defaultStyle() );

virtual
 ~IDrawingCanvas( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF2(Style, IDrawingCanvas, ICanvas, IWindow);
// style class definition
static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU useDefaultPaintHandler;

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      bool         extendedOnly = false ) const;

/*------------------------------ Graphic Group -------------------------------*/
virtual void
  setGraphicGroup   ( IGraphicGroup *group );

virtual IGraphicGroup*
  graphicGroup      ( ) const;

/*-------------------------------- GrafPort ----------------------------------*/
virtual void
  setGrafPort ( IGrafPort* grafPort );

virtual IGrafPort
 *grafPort    ( ) const;


protected:
/*----------------------------- Canvas Support -------------------------------*/
virtual ISize
  calcMinimumSize   ( ) const;

private:
/*------------------------------ Hidden Members ------------------------------*/
  IDrawingCanvas  ( const IDrawingCanvas& drawingCanvas );
IDrawingCanvas
 &operator=       ( const IDrawingCanvas& drawingCanvas );

/*--------------------------------- Private ----------------------------------*/
static Style
  fgCurrentDefaultStyle;

enum EGraphicsUsed {
  kNoneSpecified=0,
  kOldGraphics,
  kNewGraphics
};

IGraphicGroup
 *fGroup;
IGrafPort
 *fPort;
IDrawingCanvasData
 *fDrawingCanvasData;
EGraphicsUsed
  fContextType,
  fListType;
friend class IDrawingCanvasDrawHandler;

/*----------------------------- Obsolete Members -----------------------------*/
#ifdef IC_PMWIN
#if ( IC_OBSOLETE <= IC_OBSOLETE_3 )
IGList
 *fList;
IGraphicContext
 *fGc;
static void setOldCalcMinimumSize (PTROldCalcMinimumSize);
static void setOldPaintWindow (PTROldPaintWindow);

public:
IDrawingCanvas
 &setGraphicList    ( IGList* list );
IGList*
  graphicList       ( ) const;
IDrawingCanvas
 &setGraphicContext ( IGraphicContext* graphicContext );
IGraphicContext
 *graphicContext    ( ) const;
#endif // IC_OBSOLETE
#endif // IC_PMWIN

}; // IDrawingCanvas

INESTEDBITFLAGCLASSFUNCS(Style, IDrawingCanvas)

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _IDRAWCV_
