// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 30 1.5.1.4 source/core/collect/idqutab.h, collection, ioc.v400, 980918 
#ifndef _IDQUTAB_
#define _IDQUTAB_

#include <ilanglvl.hpp>
#include <iadqu.h>
#include <iicseq.h>

#include <iivseq.h>

#include <iiseqtab.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGDequeAsTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGDequeAsTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGDequeAsTable
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGDequeAsTableCursor
                            (IGDequeAsTable
                              <
                               Element, ElementOps> const&);

  IGDequeAsTableCursor <Element, ElementOps>&
           operator=        (IGDequeAsTableCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGDequeAsTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGDequeAsTable :
  public IADeque <Element> {
protected:

  typedef  IGDequeAsTable <Element, ElementOps> Self;

  typedef  ISequenceAsTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSequenceImpl
            <PureImplementation> Implementation;
#endif

#define IGDequeAsTableTypedef(Element, ElementOps)\
  typedef  ISequenceAsTableOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGDequeAsTableTypedef (Element, ElementOps);

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

  typedef  IGDequeAsTableCursor
            <Element, ElementOps> Cursor;




           IGDequeAsTable
                            (INumber = 100);

           IGDequeAsTable
                            (IGDequeAsTable
                              <
                               Element, ElementOps> const&);

  IGDequeAsTable <Element, ElementOps>&
           operator=        (IGDequeAsTable
                              <
                               Element, ElementOps> const&);



















protected:

           IGDequeAsTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGDequeAsTable
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGDequeAsTableCursor <Element, ElementOps>;






















};

template <class Element>
class IDequeAsTable :
  public IGDequeAsTable
          <Element, IStdOps <Element> > {

  typedef  IGDequeAsTable
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IDequeAsTable <Element> Self;

#define IDequeAsTableTypedef(Element)\
  typedef  ISequenceAsTableOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IDequeAsTable
                            (INumber = 100);

















protected:

           IDequeAsTable
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGDequeAsTable :
  public IGDequeAsTable
          <Element, ElementOps > {

  typedef  IVGDequeAsTable
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGDequeAsTable
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSequenceImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSequenceImpl
            <IVSequenceImpl
              <PureImplementation> > Implementation;
#endif

#define IVGDequeAsTableTypedef(Element, ElementOps)\
  typedef  ISequenceAsTableOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGDequeAsTableTypedef (Element, ElementOps);

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IVGDequeAsTable
                            (INumber = 100);

















protected:

           IVGDequeAsTable
                              (PureImplementation&);

private:












};

template <class Element>
class IVDequeAsTable :
  public IVGDequeAsTable
          <Element, IStdOps <Element> > {

  typedef  IVGDequeAsTable
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVDequeAsTable <Element> Self;

#define IVDequeAsTableTypedef(Element)\
  typedef  IVSequenceAsTableOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IVDequeAsTable
                            (INumber = 100);

















protected:

           IVDequeAsTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <idqutab.inl>


#pragma info (restore)


#endif // _IDQUTAB_
