// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 28 1.5.1.4 source/core/collect/idqulst.h, collection, ioc.v400, 980918 
#ifndef _IDQULST_
#define _IDQULST_

#include <ilanglvl.hpp>
#include <iadqu.h>
#include <iicseq.h>

#include <iivseq.h>

#include <iiseqlst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGDequeAsList;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGDequeAsListCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGDequeAsList
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGDequeAsListCursor
                            (IGDequeAsList
                              <
                               Element, ElementOps> const&);

  IGDequeAsListCursor <Element, ElementOps>&
           operator=        (IGDequeAsListCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGDequeAsListCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGDequeAsList :
  public IADeque <Element> {
protected:

  typedef  IGDequeAsList <Element, ElementOps> Self;

  typedef  ISequenceAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSequenceImpl
            <PureImplementation> Implementation;
#endif

#define IGDequeAsListTypedef(Element, ElementOps)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGDequeAsListTypedef (Element, ElementOps);

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

  typedef  IGDequeAsListCursor
            <Element, ElementOps> Cursor;




           IGDequeAsList
                            (INumber = 100);

           IGDequeAsList
                            (IGDequeAsList
                              <
                               Element, ElementOps> const&);

  IGDequeAsList <Element, ElementOps>&
           operator=        (IGDequeAsList
                              <
                               Element, ElementOps> const&);



















protected:

           IGDequeAsList
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGDequeAsList
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGDequeAsListCursor <Element, ElementOps>;






















};

template <class Element>
class IDequeAsList :
  public IGDequeAsList
          <Element, IStdOps <Element> > {

  typedef  IGDequeAsList
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IDequeAsList <Element> Self;

#define IDequeAsListTypedef(Element)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IDequeAsList
                            (INumber = 100);

















protected:

           IDequeAsList
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGDequeAsList :
  public IGDequeAsList
          <Element, ElementOps > {

  typedef  IVGDequeAsList
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGDequeAsList
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSequenceImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSequenceImpl
            <IVSequenceImpl
              <PureImplementation> > Implementation;
#endif

#define IVGDequeAsListTypedef(Element, ElementOps)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGDequeAsListTypedef (Element, ElementOps);

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IVGDequeAsList
                            (INumber = 100);

















protected:

           IVGDequeAsList
                              (PureImplementation&);

private:












};

template <class Element>
class IVDequeAsList :
  public IVGDequeAsList
          <Element, IStdOps <Element> > {

  typedef  IVGDequeAsList
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVDequeAsList <Element> Self;

#define IVDequeAsListTypedef(Element)\
  typedef  IVSequenceAsListOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IVDequeAsList
                            (INumber = 100);

















protected:

           IVDequeAsList
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <idqulst.inl>


#pragma info (restore)


#endif // _IDQULST_
