// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 25 1.5.1.4 source/core/collect/idqudil.h, collection, ioc.v400, 980918 
#ifndef _IDQUDIL_
#define _IDQUDIL_

#include <ilanglvl.hpp>
#include <iadqu.h>
#include <iicseq.h>

#include <iivseq.h>

#include <iiseqdil.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGDequeAsDilTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGDequeAsDilTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGDequeAsDilTable
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGDequeAsDilTableCursor
                            (IGDequeAsDilTable
                              <
                               Element, ElementOps> const&);

  IGDequeAsDilTableCursor <Element, ElementOps>&
           operator=        (IGDequeAsDilTableCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGDequeAsDilTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGDequeAsDilTable :
  public IADeque <Element> {
protected:

  typedef  IGDequeAsDilTable <Element, ElementOps> Self;

  typedef  ISequenceAsDilTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSequenceImpl
            <PureImplementation> Implementation;
#endif

#define IGDequeAsDilTableTypedef(Element, ElementOps)\
  typedef  ISequenceAsDilTableOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGDequeAsDilTableTypedef (Element, ElementOps);

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

  typedef  IGDequeAsDilTableCursor
            <Element, ElementOps> Cursor;




           IGDequeAsDilTable
                            (INumber = 100);

           IGDequeAsDilTable
                            (IGDequeAsDilTable
                              <
                               Element, ElementOps> const&);

  IGDequeAsDilTable <Element, ElementOps>&
           operator=        (IGDequeAsDilTable
                              <
                               Element, ElementOps> const&);



















protected:

           IGDequeAsDilTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGDequeAsDilTable
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGDequeAsDilTableCursor <Element, ElementOps>;






















};

template <class Element>
class IDequeAsDilTable :
  public IGDequeAsDilTable
          <Element, IStdOps <Element> > {

  typedef  IGDequeAsDilTable
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IDequeAsDilTable <Element> Self;

#define IDequeAsDilTableTypedef(Element)\
  typedef  ISequenceAsDilTableOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IDequeAsDilTable
                            (INumber = 100);

















protected:

           IDequeAsDilTable
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGDequeAsDilTable :
  public IGDequeAsDilTable
          <Element, ElementOps > {

  typedef  IVGDequeAsDilTable
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGDequeAsDilTable
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSequenceImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSequenceImpl
            <IVSequenceImpl
              <PureImplementation> > Implementation;
#endif

#define IVGDequeAsDilTableTypedef(Element, ElementOps)\
  typedef  ISequenceAsDilTableOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGDequeAsDilTableTypedef (Element, ElementOps);

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IVGDequeAsDilTable
                            (INumber = 100);

















protected:

           IVGDequeAsDilTable
                              (PureImplementation&);

private:












};

template <class Element>
class IVDequeAsDilTable :
  public IVGDequeAsDilTable
          <Element, IStdOps <Element> > {

  typedef  IVGDequeAsDilTable
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVDequeAsDilTable <Element> Self;

#define IVDequeAsDilTableTypedef(Element)\
  typedef  IVSequenceAsDilTableOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IVDequeAsDilTable
                            (INumber = 100);

















protected:

           IVDequeAsDilTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <idqudil.inl>


#pragma info (restore)


#endif // _IDQUDIL_
