// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 23 1.6.1.4 source/core/collect/idqu.h, collection, ioc.v400, 980918 
#ifndef _IDQU_
#define _IDQU_

#include <ilanglvl.hpp>
#include <iadqu.h>
#include <iicseq.h>

#include <iivseq.h>

#include <iiseqlst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGDeque;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGDequeCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGDeque
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGDequeCursor
                            (IGDeque
                              <
                               Element, ElementOps> const&);

  IGDequeCursor <Element, ElementOps>&
           operator=        (IGDequeCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGDequeCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGDeque :
  public IADeque <Element> {
protected:

  typedef  IGDeque <Element, ElementOps> Self;

  typedef  ISequenceAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSequenceImpl
            <PureImplementation> Implementation;
#endif

#define IGDequeTypedef(Element, ElementOps)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGDequeTypedef (Element, ElementOps);

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

  typedef  IGDequeCursor
            <Element, ElementOps> Cursor;




           IGDeque
                            (INumber = 100);

           IGDeque
                            (IGDeque
                              <
                               Element, ElementOps> const&);

  IGDeque <Element, ElementOps>&
           operator=        (IGDeque
                              <
                               Element, ElementOps> const&);



















protected:

           IGDeque
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGDeque
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGDequeCursor <Element, ElementOps>;






















};

template <class Element>
class IDeque :
  public IGDeque
          <Element, IStdOps <Element> > {

  typedef  IGDeque
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IDeque <Element> Self;

#define IDequeTypedef(Element)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IDeque
                            (INumber = 100);

















protected:

           IDeque
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGDeque :
  public IGDeque
          <Element, ElementOps > {

  typedef  IVGDeque
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGDeque
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSequenceImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSequenceImpl
            <IVSequenceImpl
              <PureImplementation> > Implementation;
#endif

#define IVGDequeTypedef(Element, ElementOps)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGDequeTypedef (Element, ElementOps);

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IVGDeque
                            (INumber = 100);

















protected:

           IVGDeque
                              (PureImplementation&);

private:












};

template <class Element>
class IVDeque :
  public IVGDeque
          <Element, IStdOps <Element> > {

  typedef  IVGDeque
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVDeque <Element> Self;

#define IVDequeTypedef(Element)\
  typedef  IVSequenceAsListOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IVDeque
                            (INumber = 100);

















protected:

           IVDeque
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <idqu.inl>


#pragma info (restore)


#endif // _IDQU_
