// Revision: 11 1.3.1.3 source/ui/drag/idmtgtrn.hpp, dragdrop, ioc.v400, 980918 
#ifndef _IDMTGTRN_
#define _IDMTGTRN_
/*******************************************************************************
* FILE NAME: idmtgtrn.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDMTargetRenderer                                                        *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved                    *
*                                                                              *
*******************************************************************************/
#include <idmcomm.hpp>
#include <idmrendr.hpp>
#include <idmitem.hpp>
#include <istring.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

struct  _DRAGTRANSFER;

class   IDMTargetDropEvent;
class   IDMTargetEndEvent;
class   IDMTargetRendererData;

#pragma enum(4)
#pragma pack(push,4)

class IDMTargetRenderer : public IDMRenderer {
typedef IDMRenderer
  Inherited;
typedef IDM::DropIndicator
  DropIndicator;
public:

/*------------------------------- Constructors -------------------------------*/
  IDMTargetRenderer  ( const char* rmfs, const char* type = IDM::any );

  IDMTargetRenderer  ( );

virtual
  ~IDMTargetRenderer ( );

/*-------------------------- Source and Target Rendering ---------------------*/
virtual IDMTargetRenderer
 &targetRender             ( IDMTargetDropEvent&    event,
                             const IDMItem::Handle& dragItem ),

#ifndef IC_MOTIF_FLAGNOP
#ifndef IC_WIN_FLAGNOP
 &targetRenderPrepare      ( IDMTargetDropEvent&    event,
                             const IDMItem::Handle& dragItem ),
 &targetRenderComplete     ( IDMTargetEndEvent&     event ),
#endif
#endif
 &informSourceOfCompletion ( const IDMItem::Handle& dragItem,
                             IDM::RenderCompletion  code =
                                           IDM::targetSuccessful );

virtual DropIndicator
  canRender                ( const IDMItem::Handle& dragItem );

virtual bool
  supportsOperation        ( const IDMItem::Handle& dragItem );

protected:
/*----------------------------- Renderer Specifics ---------------------------*/
#ifndef IC_MOTIF_FLAGNOP
virtual bool
  renderAtSource  ( IDMTargetDropEvent&    event,
                    const IDMItem::Handle& dragItem ),
  prepareAtSource ( IDMTargetDropEvent&    event,
                    const IDMItem::Handle& dragItem ),
  renderComplete  ( const IDMItem::Handle& dragItem,
                    void*                  pBuffer );
#endif

virtual IString
  renderToName    ( const IDMItem::Handle& dragItem );

private:
/*--------------------------------- Private ----------------------------------*/

_DRAGTRANSFER
 *pPMDragTransfer;

#ifndef IC_MOTIF_FLAGNOP
_DRAGTRANSFER
 *allocDragTransfer ( IDMTargetDropEvent&    dropEvent,
                      const IDMItem::Handle& pDI );
#endif

_DRAGTRANSFER
 *dragTransfer      ( ) const;

IDMTargetRendererData
 *fDMTargetRendererData;

}; // class IDMTargetRenderer

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _IDMTGTRN_
