// Revision: 10 1.4.1.4 source/ui/drag/idmtgtop.hpp, dragdrop, ioc.v400, 980918 
#ifndef _IDMTGTOP_
#define _IDMTGTOP_
/*******************************************************************************
* FILE NAME: idmtgtop.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDMTargetOperation                                                       *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved                    *
*                                                                              *
*******************************************************************************/
#include <idmoper.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IDMItemSeq;
class IDMImage;
class IDMTargetOperationData;

#pragma enum(4)
#pragma pack(push,4)

class IDMTargetOperation : public IDMOperation {
typedef IDMOperation
  Inherited;
typedef IDM::DropStyle
  DropStyle;
public:

/*------------------------------- Constructors -------------------------------*/
  IDMTargetOperation  ( IDMTargetEnterEvent& event );

virtual
  ~IDMTargetOperation ( );

/*------------------------ IDMTargetOperation::Handle ------------------------*/
typedef ICountedPointerTo< IDMTargetOperation > Handle;

/*----------------------------- Operation Services ---------------------------*/
static IDMTargetOperation::Handle
  instanceFor        ( IDMTargetEnterEvent& event );

static IDMTargetOperation::Handle
  targetOperation    ( );

static void
  setTargetOperation ( IDMTargetOperation::Handle tgtOperation );

virtual bool
  firstTimeEntered () const;

IDMTargetOperation
 &setFirstTimeEntered ( bool  flag );

/*---------------------------- Container Support -----------------------------*/
bool
  wasDragAfter          ( ) const,
  isStyle               ( DropStyle              dropStyle );

IDMTargetOperation
 &setDropOffset         ( const ISize&           newPointerOffset ),
 &setStyle              ( DropStyle              dropStyle );

ISize
  dropOffset            ( ) const;

DropStyle
  style                 ( ) const;

IPoint
  dropPosition          ( const IDMItem::Handle& dragItem,
                          IDMTargetDropEvent&    event ),
  positionRelativeTo    ( const IDMItem::Handle& item,
                          IDMTargetDropEvent&    event );

private:
/*--------------------------------- Private ----------------------------------*/

friend class IDMTargetHandler;

static IDMTargetOperation::Handle
  pDMTgtOpHandle;

bool
  bWasDragAfter,
  bNotDragLeave,
  bDrop;

ISize
  sizeDropOffset;

DropStyle
  dropStyle;

IDMTargetOperationData
 *fDMTargetOperationData;

bool
 bFirstTimeEntered;

}; // IDMTargetOperation

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif //_IDMTGTOP_
