// Revision: 09 1.3.1.3 source/ui/drag/idmtgth.hpp, dragdrop, ioc.v400, 980918 
#ifndef _IDMTGTH_
#define _IDMTGTH_
/*******************************************************************************
* FILE NAME: idmtgth.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDMTargetHandler                                                         *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved                    *
*                                                                              *
*******************************************************************************/
#include <idmhndlr.hpp>
#include <idmtgtop.hpp>
#include <idmtgtrn.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IDMTargetRenderer;
class IWindow;
class IEntryField;
class IMultiLineEdit;
class IContainerControl;
class IDMTargetEnterEvent;
class IDMTargetLeaveEvent;
class IDMTargetDropEvent;
class IDMTargetHelpEvent;
class IDMTargetEndEvent;
class IDMTargetHandlerData;

#pragma enum(4)
#pragma pack(push,4)

class IDMTargetHandler : public IDMHandler {
typedef IDMHandler
  Inherited;
public:

/*------------------------------- Constructors -------------------------------*/
  IDMTargetHandler  ( IWindow*           window );

  IDMTargetHandler  ( IEntryField*       entryField );

  IDMTargetHandler  ( IMultiLineEdit*    multiLineEdit );

  IDMTargetHandler  ( IContainerControl* containerControl );

  IDMTargetHandler  ( );

virtual
  ~IDMTargetHandler ( );

/*-------------------------- Renderer Processing -----------------------------*/
virtual unsigned
  numberOfRenderers ( );

virtual IDMTargetRenderer
 *renderer          ( unsigned                 position );

virtual IDMTargetHandler
 &replaceRenderer   ( unsigned                 position,
                      const IDMTargetRenderer& replacement ),
 &addRenderer       ( const IDMTargetRenderer& newRenderer ),
 &removeRenderer    ( const IDMTargetRenderer& rendererToRemove ),
 &setRenderer       ( const IDMTargetRenderer& newRenderer );


protected:
/*---------------------------- Event Dispatching -----------------------------*/
virtual bool
  dispatchHandlerEvent ( IEvent&              event );

/*---------------------------- Event Processing ------------------------------*/
virtual bool
  targetEnter          ( IDMTargetEnterEvent& event ),
  targetLeave          ( IDMTargetLeaveEvent& event ),
  targetDrop           ( IDMTargetDropEvent&  event,
                         bool              container = true ),
  targetHelp           ( IDMTargetHelpEvent&  event );
#ifndef IC_MOTIF_FLAGNOP
virtual bool
  targetEnd            ( IDMTargetEndEvent&   event );
#endif

/*------------------------------ Implementation ------------------------------*/
virtual IDMTargetOperation::Handle
  allocateOperation ( IDMTargetEnterEvent&              event ) const;

virtual bool
  findRenderersFor  ( const IDMTargetOperation::Handle& targetOperation );

virtual unsigned
  findRendererFor   ( const IDMItem::Handle&            item );

private:
/*------------------------------ Hidden Members ------------------------------*/
virtual IDMHandler
 &replaceRenderer ( unsigned           position,
                    const IDMRenderer& replacement ),
 &addRenderer     ( const IDMRenderer& newRenderer ),
 &removeRenderer  ( unsigned           position ),
 &removeRenderer  ( const IDMRenderer& rendererToRemove ),
 &setRenderer     ( const IDMRenderer& newRenderer );

IDMTargetHandlerData
 *fDMTargetHandlerData;

}; // IDMTargetHandler

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _IDMTGTH_
