// Revision: 05 1.3.1.4 source/ui/drag/idmtbbit.hpp, dragdrop, ioc.v400, 980918 
#ifndef _IDMTBBIT_
#define _IDMTBBIT_
/*******************************************************************************
* FILE NAME: idmtbbit.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDMTBarButtonItem                                                        *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved                    *
*                                                                              *
*******************************************************************************/
#include <idmitem.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IDMSourceOperation;
class IToolBar;
class IToolBarButton;
class IDMTBarButtonItemData;

#pragma enum(4)
#pragma pack(push,4)

class IDMTBarButtonItem : public IDMItem {
typedef IDMItem
  Inherited;
public:

/*------------------------------- Constructors -------------------------------*/
  IDMTBarButtonItem  ( IDMSourceOperation*    sourceOperation );

  IDMTBarButtonItem  ( const IDMItem::Handle& dragItem );

virtual
  ~IDMTBarButtonItem ( );


/*------------------------------ Source Items --------------------------------*/
static bool
  generateSourceItems ( IDMSourceOperation* sourceOperation );

/*----------------------- Tool Bar Button Operations -------------------------*/
virtual unsigned long
  supportedOperationsFor ( const IString& selectedRMFs ) const;

/*------------------------------ Drop Processing -----------------------------*/
virtual bool
  targetDrop ( IDMTargetDropEvent& event );

/*------------------------------ Shredder Support ----------------------------*/
#ifndef IC_MOTIFWIN_FLAGNOP
virtual bool
  sourceDiscard ( IDMSourceDiscardEvent& event );
#endif

/*------------------------- Source and Target Tool Bar -----------------------*/
virtual IToolBar
 *sourceToolBar       ( ) const,
 *targetToolBar       ( ) const;

virtual IToolBarButton
 *sourceToolBarButton ( ) const,
 *targetToolBarButton ( ) const;

private:
/*--------------------------------- Private ----------------------------------*/
IToolBarButton
 *pSourceBtn,
 *pTargetBtn;

IDMTBarButtonItemData
 *fDMTBarButtonItemData;

}; // IDMTBarButtonItem

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif


#endif // _IDMTBBIT_
