// Revision: 03 1.3.1.3 source/ui/drag/idmsrcrn.hpp, dragdrop, ioc.v400, 980918 
#ifndef _IDMSRCRN_
#define _IDMSRCRN_
/*******************************************************************************
* FILE NAME: idmsrcrn.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDMSourceRenderer                                                        *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved                    *
*                                                                              *
*******************************************************************************/
#include <idmrendr.hpp>
#include <idmcomm.hpp>
#include <istring.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

struct  _DRAGTRANSFER;

class   IDMSourceRenderEvent;
class   IDMSourcePrepareEvent;
class   IDMSourceEndEvent;
class   IDMSourceDiscardEvent;
class   IDMSourcePrintEvent;
class   IDMSourceRendererData;

#pragma enum(4)
#pragma pack(push,4)


class IDMSourceRenderer : public IDMRenderer {
typedef IDMRenderer
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IDMSourceRenderer  ( const char* rmfs, const char* type = IDM::any );

  IDMSourceRenderer  ( );

virtual
  ~IDMSourceRenderer ( );

/*----------------------- Source and Target Rendering ------------------------*/
virtual IDMSourceRenderer
#ifndef IC_MOTIF_FLAGNOP
 &sourceRender             ( IDMSourceRenderEvent&  event ),
 &sourcePrepare            ( IDMSourcePrepareEvent& event ),
#endif
 &sourceEnd                ( IDMSourceEndEvent&     event );
#ifndef IC_MOTIF_FLAGNOP
#ifndef IC_WIN_FLAGNOP
virtual IDMSourceRenderer
 &sourceDiscard            ( IDMSourceDiscardEvent& event ),
 &sourcePrint              ( IDMSourcePrintEvent&   event ),
 &informTargetOfCompletion ( IDMSourceRenderEvent&  event );
#endif
#endif

virtual bool
  canRender     ( const IString&         types );

protected:
/*----------------------------- Renderer Specifics ---------------------------*/
virtual bool
#ifndef IC_MOTIF_FLAGNOP
  doRender        ( IDMSourceRenderEvent&  event ),
  doRenderPrepare ( IDMSourcePrepareEvent& event ),
#endif
  doRenderEnd     ( IDMSourceEndEvent&     event ),
#ifndef IC_WIN_FLAGNOP
  doDiscard       ( IDMSourceDiscardEvent& event ),
  doPrint         ( IDMSourcePrintEvent&   event );
#endif

private:
/*--------------------------------- Private ----------------------------------*/

_DRAGTRANSFER
 *pPMDragTransfer;

IDMSourceRendererData
 *fDMSourceRendererData;

}; // class IDMSourceRenderer

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _IDMSRCRN_
