// Revision: 02 1.3.1.5 source/ui/drag/idmsrcop.hpp, dragdrop, ioc.v400, 980918 
#ifndef _IDMSRCOP_
#define _IDMSRCOP_
/*******************************************************************************
* FILE NAME: idmsrcop.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDMSourceOperation                                                       *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved                    *
*                                                                              *
*******************************************************************************/
#include <idmoper.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IDMSourceBeginEvent;
class IDMItemSeq;
class IDMImage;
class IDMSourceOperationData;

#pragma enum(4)
#pragma pack(push,4)


class IDMSourceOperation : public IDMOperation {
typedef IDMOperation
  Inherited;
typedef IDM::DragImageStyle
  DragImageStyle;
public:

/*------------------------------- Constructors -------------------------------*/
  IDMSourceOperation     ( IDMSourceBeginEvent& event,
                           DragImageStyle       dragStyle = IDM::systemImages );

virtual
  ~IDMSourceOperation    ( );

/*------------------------ IDMSourceOperation::Handle ------------------------*/
typedef ICountedPointerTo< IDMSourceOperation > Handle;

/*---------------------------- Drag Image Support ----------------------------*/
#ifndef IC_MOTIFWIN_FLAGNOP
virtual DragImageStyle
  imageStyle            ( ) const;

IPair
  stackingPercentage    ( ) const;

virtual IDMSourceOperation
 &setImageStyle         ( DragImageStyle dragImageStyle = IDM::systemImages ),
 &setStackingPercentage ( const IPair&   stackingPercentage );
#endif

/*-------------------------- Pointing Device Position ------------------------*/
virtual ISize
  pointerOffset         ( ) const;

virtual IDMSourceOperation
 &setPointerOffset      ( const ISize&   offset );

/*----------------------------- Operation Services ---------------------------*/
virtual unsigned long
  operation          ( ) const;

#ifdef IC_MOTIFPM
static Handle
  operationFrom      ( _DRAGINFO* dragInformation );
#endif

#ifdef IC_MOTIFWIN
static IDMSourceOperation::Handle
  sourceOperation    ( );

static void
  setSourceOperation ( IDMSourceOperation::Handle srcOperation );
#endif

/*------------------------------- Implementation -----------------------------*/
IDMSourceOperation
 &begin                 ( );

private:
/*--------------------------------- Private ----------------------------------*/

#ifdef IC_MOTIFWIN
static IDMSourceOperation::Handle
  pDMSrcOpHandle;
#endif

ISize
  ptrOffset,
  totalImgOffset;

DragImageStyle
  drgImgStyle;

IPair
  stackingPct;

ISize
  totalImageOffset ( );

void
  storeImageOffset ( IDMImage* pIDMImage );

IDMSourceOperationData
 *fDMSourceOperationData;

}; // IDMSourceOperation

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif //_IDMSRCOP_
