// Revision: 01 1.3.1.3 source/ui/drag/idmsrch.hpp, dragdrop, ioc.v400, 980918 
#ifndef _IDMSRCH_
#define _IDMSRCH_
/*******************************************************************************
* FILE NAME: idmsrch.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDMSourceHandler                                                         *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved                    *
*                                                                              *
*******************************************************************************/
#include <idmcomm.hpp>
#include <idmhndlr.hpp>
#include <idmsrcop.hpp>
#include <idmsrcrn.hpp>
#include <idmitem.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IWindow;
class IEntryField;
class IMultiLineEdit;
class IContainerControl;
class IDMSourceBeginEvent;
class IDMSourcePrepareEvent;
class IDMSourceRenderEvent;
class IDMSourceEndEvent;
class IDMSourceDiscardEvent;
class IDMSourcePrintEvent;
class IDMSourceHandlerData;

#pragma enum(4)
#pragma pack(push,4)


class IDMSourceHandler : public IDMHandler {
typedef IDMHandler
  Inherited;
typedef IDM::DragImageStyle
  DragImageStyle;
public:

/*------------------------------- Constructors -------------------------------*/
  IDMSourceHandler  ( IWindow*           window );

  IDMSourceHandler  ( IEntryField*       entryField );

  IDMSourceHandler  ( IMultiLineEdit*    multiLineEdit );

  IDMSourceHandler  ( IContainerControl* containerControl );

  IDMSourceHandler  ( );

virtual
  ~IDMSourceHandler ( );

/*--------------------------- Renderer Processing ----------------------------*/
virtual unsigned
  numberOfRenderers ( );

virtual IDMSourceRenderer
 *renderer          ( unsigned                 position );

virtual IDMSourceHandler
 &replaceRenderer   ( unsigned                 position,
                      const IDMSourceRenderer& replacement ),
 &addRenderer       ( const IDMSourceRenderer& newRenderer ),
 &removeRenderer    ( const IDMSourceRenderer& rendererToRemove ),
 &setRenderer       ( const IDMSourceRenderer& newRenderer );

protected:
/*----------------------------- Event Dispatching ----------------------------*/
virtual bool
  dispatchHandlerEvent ( IEvent&                event );

/*----------------------------- Event Processing -----------------------------*/
virtual bool
  sourceBegin          ( IDMSourceBeginEvent&   event,
                         bool                container = true ),
#ifndef IC_MOTIF_FLAGNOP
  sourcePrepare        ( IDMSourcePrepareEvent& event ),
  sourceRender         ( IDMSourceRenderEvent&  event ),
#endif
  sourceEnd            ( IDMSourceEndEvent&     event );
#ifndef IC_MOTIF_FLAGNOP
virtual bool
  sourceDiscard        ( IDMSourceDiscardEvent& event ),
  sourcePrint          ( IDMSourcePrintEvent&   event );
#endif

/*------------------------------ Implementation ------------------------------*/
virtual IDMSourceOperation::Handle
  allocateOperation ( IDMSourceBeginEvent&              event,
                      DragImageStyle                    dragItemStyle ) const;

virtual bool
  findRenderersFor  ( const IDMSourceOperation::Handle& sourceOperation );

virtual unsigned
  findRendererFor   ( const IDMItem::Handle&            item );

private:
/*------------------------------ Hidden Members ------------------------------*/
virtual IDMHandler
 &replaceRenderer ( unsigned           position,
                    const IDMRenderer& replacement ),
 &addRenderer     ( const IDMRenderer& newRenderer ),
 &removeRenderer  ( unsigned           position ),
 &removeRenderer  ( const IDMRenderer& rendererToRemove ),
 &setRenderer     ( const IDMRenderer& newRenderer );

/*--------------------------------- Private ----------------------------------*/
void
  resolveRMFConflict (IDMItem::Handle&   item,
                      IDMSourceRenderer* pIDMSrcRenderer);

IDMSourceHandlerData
 *fDMSourceHandlerData;

}; // IDMSourceHandler

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif //_IDMSRCH_
