// Revision: 97 1.4.1.3 source/ui/drag/idmrendr.hpp, dragdrop, ioc.v400, 980918 
#ifndef _IDMRENDR_
#define _IDMRENDR_
/*******************************************************************************
* FILE NAME: idmrendr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDMRenderer                                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved                    *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>
#include <istring.hpp>

#include <iuipl.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IDMSourceRenderer;
class IDMTargetRenderer;
class IDMRendererData;

#pragma enum(4)
#pragma pack(push,4)

class IDMRenderer  {
public:

/*------------------------------- Constructors -------------------------------*/
  IDMRenderer  ( const char* rmfs, const char* types );

  IDMRenderer  ( );

virtual
  ~IDMRenderer ( );

/*------------------------- Supported Types and RMFs -------------------------*/
virtual IString
  supportedTypes    ( ) const,
  supportedRMFs     ( ) const;

virtual IDMRenderer
 &setSupportedTypes ( const char* types ),
 &setSupportedRMFs  ( const char* rmfs );

/*----------------------------- Default Renderers ----------------------------*/
static IDMSourceRenderer
 &defaultSourceRenderer    ( );

static IDMTargetRenderer
 &defaultTargetRenderer    ( );

static void
  setDefaultSourceRenderer ( IDMSourceRenderer& sourceRenderer ),
  setDefaultTargetRenderer ( IDMTargetRenderer& targetRenderer );

private:
/*--------------------------------- Private ----------------------------------*/

IString
  strTypes,
  strRMFs;

static IDMSourceRenderer
 *pSource;

static IDMTargetRenderer
 *pTarget;

IDMRendererData
 *fDMRendererData;

}; // class IDMRenderer

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _IDMRENDR_
