// Revision: 95 1.5.1.3 source/ui/drag/idmprov.hpp, dragdrop, ioc.v400, 980918 
#ifndef _IDMPROV_
#define _IDMPROV_
/*******************************************************************************
* FILE NAME: idmprov.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDMItemProvider                                                          *
*       IDMItemProviderFor< >                                                  *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved                    *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>
#include <idmsrcop.hpp>
#include <idmitem.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IDMTargetEnterEvent;
class IDMTargetLeaveEvent;
class IDMTargetHelpEvent;
class IDMItemProviderData;

#pragma enum(4)
#pragma pack(push,4)

class IDMItemProvider {
public:

/*------------------------------- Constructors -------------------------------*/
  IDMItemProvider  ( );

virtual
  ~IDMItemProvider ( );

/*----------------------------- Drag Item Support ----------------------------*/
virtual bool
  provideSourceItems    ( const IDMSourceOperation::Handle& sourceOperation ),
  provideEnterSupport   ( IDMTargetEnterEvent&              event ),
  provideLeaveSupport   ( IDMTargetLeaveEvent&              event );
#ifndef IC_WIN_FLAGNOP
virtual bool
  provideHelpFor        ( IDMTargetHelpEvent&               event );
#endif

virtual IDMItem::Handle
  provideTargetItemFor  ( const IDMItem::Handle&            dragItem );

private:
/*--------------------------------- Private ----------------------------------*/

IDMItemProviderData
 *fDMItemProviderData;

}; // class IDMItemProvider


template < class T >
class IDMItemProviderFor : public IDMItemProvider {
typedef IDMItemProvider
  Inherited;
public:

/*------------------------------- Constructors -------------------------------*/
  IDMItemProviderFor() ;
  virtual
    ~IDMItemProviderFor() ;

/*----------------------------- Drag Item Support ----------------------------*/
virtual bool
  provideSourceItems   ( const IDMSourceOperation::Handle& sourceOperation ) ;

virtual IDMItem::Handle
  provideTargetItemFor ( const IDMItem::Handle& dragItem ) ;

}; // class IDMItemProviderFor

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <idmprov.c>

#endif //_IDMPROV_
