// Revision: 91 1.4.1.4 source/ui/drag/idmoper.hpp, dragdrop, ioc.v400, 980918 
#ifndef _IDMOPER_
#define _IDMOPER_
/*******************************************************************************
* FILE NAME: idmoper.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDMOperation                                                             *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved                    *
*                                                                              *
*******************************************************************************/
#include <imrefcnt.hpp>
#include <icntptr.hpp>
#include <ipoint.hpp>
#include <ihandle.hpp>
#include <idmitem.hpp>
#include <idmcomm.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#ifdef IC_PM
struct _DRAGINFO;
#endif

#ifdef IC_MOTIFWIN
class IDragInfo;
typedef IDragInfo _DRAGINFO;
#endif


class  IContainerObject;
class  IContainerControl;
class  IDMSourceBeginEvent;
class  IDMTargetEnterEvent;
class  IDMItemSeq;
class  IDMOperationData;
class  IDMSourceOperationData;

#pragma enum(4)
#pragma pack(push,4)


class IDMOperation : public IMRefCounted {
typedef IMRefCounted
  Inherited;
typedef IDM::Source
  Source;
public:

/*------------------------------- Drag Operations ----------------------------*/
virtual unsigned long
  operation        ( ) const;

virtual IDMOperation
  &setOperation    ( unsigned long op );

static const unsigned long
  IC_IMPORTU drag,
  IC_IMPORTU copy,
  IC_IMPORTU link,
  IC_IMPORTU move,
  IC_IMPORTU unknown;

/*-------------------------- Pointing Device Position ------------------------*/
virtual IPoint
  position              ( ) const;

virtual IDMOperation
 &setPosition           ( IPoint        position );

/*----------------------------- Drag Source Device ---------------------------*/
virtual Source
  source                ( ) const;

virtual IDMOperation
 &setSource             ( Source        source );

/*----------------------- Source and Target Window Support -------------------*/
virtual IWindowHandle
  sourceWindowHandle    ( ) const,
  targetWindowHandle    ( ) const;

virtual IWindow
 *sourceWindow          ( ) const,
 *targetWindow          ( ) const;

virtual IDMOperation
 &setSourceWindowHandle ( IWindowHandle window ),
 &setTargetWindowHandle ( IWindowHandle window );

/*-------------------------------- Drag Items --------------------------------*/
unsigned
  numberOfItems     ( );

IDMItem::Handle
  item              ( unsigned               position );

IDMOperation
 &replaceItem       ( unsigned               position,
                      const IDMItem::Handle& replacement ),
 &addItem           ( const IDMItem::Handle& newItem ),
 &removeItem        ( unsigned               position ),
 &removeItem        ( const IDMItem::Handle& itemToRemove );

/*------------------------------ Container Support ---------------------------*/
IContainerObject
 *containerObject        ( ) const;

IDMOperation
 &setContainerObject     ( IContainerObject*  object ),
 &setContainerRefreshOff ( IContainerControl* container ),
 &setContainerRefreshOn  ( );

/*------------------------------- Diagnostics --------------------------------*/
static bool
  debugSupport();

static void
  setDebugSupport(bool debugSupport = true);

protected:
/*------------------------------- Constructors -------------------------------*/
  IDMOperation     ( IDMSourceBeginEvent& event );

  IDMOperation     ( IDMTargetEnterEvent& event );

virtual
  ~IDMOperation    ( );

/*----------------------------- Operation Services ---------------------------*/
_DRAGINFO
 *dragInfo           ( ) const;

bool
  dragWasInterrupted ( ) const;

#ifdef IC_WIN
friend class IDMSourceOperationData;
#endif

IDMOperation
 &setDragInfo        ( _DRAGINFO* dragInfo ),
 &setDragResult      ( bool    result );

private:
/*--------------------------------- Private ----------------------------------*/
#ifdef IC_MOTIFWIN
friend class IDragInfoWrapper;
#endif

unsigned long
  op;

IWindowHandle
  srcWindowHandle,
  tgtWindowHandle;

Source
  src;

IPoint
  pos;

IContainerObject
 *pCnrObj;

IContainerControl
 *pCnrRefresh;

_DRAGINFO
 *pPMDragInfo;

bool
  bDragResult;

IDMItemSeq
 *pDMItemSeqCl;

IDMItemSeq
 *itemCollection ();

IDMOperationData
 *fDMOperationData;

static bool
  fgDebugSupport;

}; // IDMOperation

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <idmoper.inl>

#endif //_IDMOPER_
