// Revision: 88 1.3.1.3 source/ui/drag/idmmleit.hpp, dragdrop, ioc.v400, 980918 
#ifndef _IDMMLEIT_
#define _IDMMLEIT_
/*******************************************************************************
* FILE NAME: idmmleit.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDMMLEItem                                                               *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved                    *
*                                                                              *
*******************************************************************************/
#include <idmitem.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IDMSourceOperation;
class IDMMLEItemData;

#pragma enum(4)
#pragma pack(push,4)

class IDMMLEItem : public IDMItem {
typedef IDMItem
  Inherited;
public:

/*------------------------------- Constructors -------------------------------*/
  IDMMLEItem  ( IDMSourceOperation*    sourceOperation );

  IDMMLEItem  ( const IDMItem::Handle& dragItem );

virtual
  ~IDMMLEItem ( );


/*------------------------------ Source Items --------------------------------*/
static bool
  generateSourceItems ( IDMSourceOperation* sourceOperation );

virtual void
 *object              ( ) const;

/*------------------------------ Drop Processing -----------------------------*/
virtual bool
  sourceEnd  ( IDMSourceEndEvent&  event ),
  targetDrop ( IDMTargetDropEvent& event );

private:
/*--------------------------------- Private ----------------------------------*/

IDMMLEItemData
 *fDMMLEItemData;

}; // IDMMLEItem

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _IDMMLEIT_
