// Revision: 86 1.3.1.4 source/ui/drag/idmmenit.hpp, dragdrop, ioc.v400, 980918 
#ifndef _IDMMENIT_
#define _IDMMENIT_
/*******************************************************************************
* FILE NAME: idmmenit.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDMMenuItem                                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved                    *
*                                                                              *
*******************************************************************************/
#ifndef IC_MOTIFWIN_FLAGNOP
#include <idmitem.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IDMSourceOperation;
class IDMMenuItemData;

#pragma enum(4)
#pragma pack(push,4)

class IDMMenuItem : public IDMItem {
typedef IDMItem
  Inherited;
public:

/*------------------------------- Constructors -------------------------------*/
  IDMMenuItem  ( IDMSourceOperation*    sourceOperation );

  IDMMenuItem  ( const IDMItem::Handle& dragItem );

virtual
  ~IDMMenuItem ( );


/*--------------------------- Menu Item Operations ---------------------------*/
virtual unsigned long
  supportedOperationsFor ( const IString& selectedRMFs ) const;

/*------------------------------ Menu Cleanup --------------------------------*/
virtual bool
  sourceEnd ( IDMSourceEndEvent& event );

/*------------------------------ Source Items --------------------------------*/
static bool
  generateSourceItems ( IDMSourceOperation* sourceOperation );

private:
/*--------------------------------- Private ----------------------------------*/
bool
  fNoDismiss;

IDMMenuItem
 &dismissMenu ( );

IDMMenuItemData
 *fDMMenuItemData;

}; // IDMMenuItem

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // IC_MOTIFWIN_FLAGNOP

#endif // _IDMMENIT_
