// Revision: 83 1.7.1.5 source/ui/drag/idmitem.hpp, dragdrop, ioc.v400, 980918 
#ifndef _IDMITEM_
#define _IDMITEM_
/*******************************************************************************
* FILE NAME: idmitem.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDMItem                                                                  *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved                    *
*                                                                              *
*******************************************************************************/
#include <iwindow.hpp>
#include <idmcomm.hpp>
#include <istring.hpp>
#include <imrefcnt.hpp>
#include <icntptr.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#ifdef IC_PM
struct _DRAGITEM;
#endif

#ifdef IC_MOTIFWIN
class IDragItem;
typedef IDragItem _DRAGITEM;
#endif

struct IDataObject;

class IDMSourceRenderEvent;
class IDMSourcePrepareEvent;
class IDMSourceEndEvent;
class IDMSourceDiscardEvent;
class IDMSourcePrintEvent;
class IDMTargetDropEvent;
class IDMTargetEndEvent;
class IDMSourceOperation;
class IDMTargetOperation;
class IDMOperation;
class IDMRenderer;
class IDMSourceRenderer;
class IDMTargetRenderer;
class IDMImage;
class IDMItemData;
class IDragItemWrapper;
class IDMSourceOperationData;
class IDMTargetOperationData;
class IDMTargetRendererData;


#pragma enum(4)
#pragma pack(push,4)

class IDMItem : public IMRefCounted {
typedef IMRefCounted
  Inherited;
typedef IDM::DropIndicator
  DropIndicator;
public:
/*------------------------------ IDMItem::Handle -----------------------------*/
typedef ICountedPointerTo< IDMItem > Handle;

/*------------------------------- Constructors -------------------------------*/
  IDMItem ( IDMSourceOperation* sourceOperation,
            const IString&      types,
            const unsigned long supportedOperations = unknown,
            const unsigned long attributes = none);

#if defined(IC_MOTIFPM) || defined(IC_WIN)
  IDMItem ( IDMTargetOperation* targetOperation,
            _DRAGITEM*          dragItem );
#endif

  IDMItem ( const IDMItem&      dragItem );

  IDMItem ( const Handle&       item );

virtual
 ~IDMItem ( );

IDMItem
 &operator = ( const IDMItem& item );

Handle
  operator = ( const Handle&  item );

/*----------------------  Supported Operations Flags  ------------------------*/
static const unsigned long
  IC_IMPORTU unknown,
  IC_IMPORTU copyable,
  IC_IMPORTU moveable,
  IC_IMPORTU linkable;

/*----------------------------  Attribute Flags ------------------------------*/
static const unsigned long
  IC_IMPORTU none,
  IC_IMPORTU open,
  IC_IMPORTU reference,
  IC_IMPORTU group,
  IC_IMPORTU container,
  IC_IMPORTU prepare,
  IC_IMPORTU removableMedia;

/*-------------------------- Item Attributes ---------------------------------*/
virtual IWindowHandle
  sourceWindowHandle    ( ) const;

virtual IWindow
 *sourceWindow          ( ) const;

virtual IString
  containerName         ( ) const,
  sourceName            ( ) const,
  targetName            ( ) const;

virtual unsigned long
  attributes            ( ) const,
  supportedOperations   ( ) const;

virtual ISize
  imageOffset           ( ) const;

IDMItem
 &setSourceWindowHandle ( IWindowHandle window ),
 &setContainerName      ( const char*   containerName ),
 &setTargetName         ( const char*   targetName ),
 &setSourceName         ( const char*   sourceName );

virtual bool
  isOpen                 ( ) const,
  isReference            ( ) const,
  isGroup                ( ) const,
  isContainer            ( ) const,
  isOnRemovableMedia     ( ) const,
  requiresPreparation    ( ) const;

virtual IDMItem
 &setRequiresPreparation ( bool requiresPrep     = true ),
 &setOpen                ( bool open             = true ),
 &setReference           ( bool reference        = true ),
 &setGroup               ( bool group            = true ),
 &setContainer           ( bool container        = true ),
 &setOnRemovableMedia    ( bool onRemovableMedia = true );

/*-------------------------- Item Operations ---------------------------------*/
virtual bool
  canBeCopied            ( ) const,
  canBeLinked            ( ) const,
  canBeMoved             ( ) const;

virtual IDMItem
 &enableCopy             ( bool        copyable = true ),
 &enableLink             ( bool        linkable = true ),
 &enableMove             ( bool        moveable = true );

virtual unsigned long
  supportedOperationsFor ( const IString& selectedRMFs ) const;

/*-------------------------------- Item Types --------------------------------*/
virtual IString
  trueType          ( ) const,
  types             ( ) const;

virtual bool
  hasType           ( const char* aType ) const;

virtual IDMItem
 &setTrueType       ( const char* aType ),
 &setTypes          ( const char* types ),
 &addType           ( const char* aType ),
 &removeType        ( const char* aType );

/*---------------------  Rendering Mechanisms and Formats  -------------------*/
virtual IString
  nativeRMF    ( ) const,
  nativeRM     ( ) const,
  nativeRF     ( ) const,
  rmfs         ( ) const;

virtual bool
  supportsRMF  ( const IString& rmf ),
  supportsRMF  ( const IString& rm,
                 const IString& rf );

virtual IDMItem
 &setNativeRMF ( const IString& rmf ),
 &setNativeRMF ( const IString& rm,
                 const IString& rf ),
 &setRMFs      ( const IString& rmfs ),
 &addRMF       ( const IString& rmf ),
 &addRMF       ( const IString& rm,
                 const IString& rf ),
 &removeRMF    ( const IString& rmf ),
 &removeRMF    ( const IString& rm,
                 const IString& rf );

static void
  appendRMF        ( IString& rmfs,
                     const IString& rmf ),
  deleteRMF        ( IString& rmfs,
                     const IString& rmf );

static IString
  compressedRMFs   ( const IString& rmfs ),
  matchingRMFs     ( const IString& rmfs1,
                     const IString& rmfs2,
                     bool        firstOnly = false ),
  rfForThisProcess ( ),
  rfFrom           ( const IString& rmf ),
  rmfFrom          ( const IString& rm,
                     const IString& rf ),
  rmFrom           ( const IString& rmf ),
  rmfsFrom         ( const IString& rmfs ),
  rmfsFrom         ( const IString& rm,
                     const IString& rf );

/*---------------------------- Selected Renderer -----------------------------*/
unsigned
  renderer       ( ) const;

IString
  selectedRMF    ( ) const;

IDMItem
 &setRenderer    ( unsigned       position ),
 &setSelectedRMF ( const IString& rmf );

/*------------------------------- Drop Status --------------------------------*/
DropIndicator
  dropStatus    ( ) const;

IDMItem
 &setDropStatus ( DropIndicator status );

/*----------------------------- Item Rendering -------------------------------*/
virtual bool
#ifndef IC_MOTIF_FLAGNOP
  sourceRender  ( IDMSourceRenderEvent&  event ),
#endif
#ifndef IC_MOTIF_FLAGNOP
#ifndef IC_WIN_FLAGNOP
  sourcePrepare ( IDMSourcePrepareEvent& event ),
#endif
#endif
  sourceEnd     ( IDMSourceEndEvent&     event );

#ifndef IC_MOTIF_FLAGNOP
#ifndef IC_WIN_FLAGNOP
virtual bool
  sourceDiscard ( IDMSourceDiscardEvent& event ),
  sourcePrint   ( IDMSourcePrintEvent&   event );
#endif
#endif
virtual bool
  targetDrop    ( IDMTargetDropEvent&    event ),
  targetEnd     ( IDMTargetEndEvent&     event );

/*---------------------------- Drag Image Support ----------------------------*/
virtual IDMImage
 &image    ( );

virtual IDMItem
 &setImage ( IDMImage& image );

bool
  hasImage ( ) const;

/*------------------------------ Source Items --------------------------------*/
static bool
  generateSourceItems ( IDMSourceOperation* sourceOperation );

/*------------------------ Source and Target Operation -----------------------*/
virtual IDMSourceOperation
 *sourceOperation ( );

virtual IDMTargetOperation
 *targetOperation ( );

/*------------------------------ Item Contents -------------------------------*/
virtual IString
  contents     ( ) const;

virtual unsigned long
  contentsSize ( ) const;

virtual bool
  setContents  ( const IString& data );

virtual void
 *object       ( ) const;

virtual IDMItem
 &setObject    ( void*          pointerToObject );

/*--------------------------- Item Utilities ---------------------------------*/
static Handle
  sourceItemFor     ( const Handle& targetItem );

bool
  isTargetTheSource ( ) const;

#ifdef IC_PM
unsigned long
  tokenForWPSObject ( ) const;
#endif

protected:
/*-------------------------------- Source Name -------------------------------*/
IString
  generateSourceName ( );

/*--------------------------------- Item Data --------------------------------*/
IString
  strContents;


private:
/*--------------------------------- Private ----------------------------------*/
friend class IDMSourceOperation;
friend class IDMTargetOperation;
friend class IDMSourceRenderEvent;
friend class IDMSourceRenderer;
friend class IDMTargetRenderer;
friend class IDMTargetEndEvent;
friend class IDMItemData;
#ifndef IC_MOTIF
friend class IDMItemUtilities;
#endif
#ifdef IC_WIN
friend class IDMTargetOperationData;
friend class IDragInfoWrapper;
friend class IDMSourceRendererData;
friend class IDMTargetRendererData;
#endif

unsigned long
  dragSupOps,
  dragAttrs;

IWindowHandle
  sourceWndh;

IDMImage
 *pIDMImage;

ISize
  sizeImageOffset;

IString
  strContainerName,
  strSourceName,
  strTargetName,
  strTypes,
  strRMFs,
  strSelectedRMF;

IDMSourceOperation
 *pDMSrcOperation;

IDMTargetOperation
 *pDMTgtOperation;

unsigned
  rendererPosition;

DropIndicator
  drpStatus;

void
 *pObject;

bool
  bTargetTheSource;

#ifdef IC_PM
_DRAGITEM
 *pPMDragItem;
#endif

#ifdef IC_MOTIFWIN
IDragItemWrapper
 *pDragItemWrapper;
#endif

_DRAGITEM
 *PMDragItem    ( );

void
  setPMDragItem ( _DRAGITEM* pDragItem ),
  asPMDragItem  ( _DRAGITEM* pDragItem );

static IString
  stringFromHandle ( const IStringHandle& hstr ),
  nextRMOrRFFrom   ( const IString&       rmfs,
                     unsigned&            position );

IStringHandle
  handleFromString ( IString              inputStr);

#ifdef IC_MOTIF
bool
  iHaveMyDragItem ( ) const;

bool
  iHaveMySrcDragItem ( ) const;
#endif
#ifndef IC_MOTIF
static void
  setHSTR          ( unsigned long&       oldHSTR,
                     const IStringHandle& newHSTR );
#endif

IDMItemData
 *fDMItemData;

}; // IDMItem

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <idmitem.inl>

#endif // _IDMITEM_
