// Revision: 80 1.4.1.4 source/ui/drag/idmimage.hpp, dragdrop, ioc.v400, 980918 
#ifndef _IDMIMAGE_
#define _IDMIMAGE_
/*******************************************************************************
* FILE NAME: idmimage.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDMImage                                                                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved                    *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>
#include <ipoint.hpp>
#include <ireslib.hpp>
#include <ibitflag.hpp>
#include <iuipl.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

struct _DRAGIMAGE;

class IDMImageData;

#pragma enum(4)
#pragma pack(push,4)

class IDMImage  {
public:

class Style;

/*------------------------------- Constructors -------------------------------*/
IDMImage    ( );
IDMImage    ( const IResourceId&    resourceId,
              bool               iconResource = true,
              const ISize&          pointerOffset = ISize(0,0),
              const ISize&          stretchSize = ISize(0,0),
              const Style&          style = defaultStyle() );

IDMImage    ( const IPointerHandle& icon,
              const ISize&          pointerOffset = ISize(0,0),
              const ISize&          stretchSize = ISize(0,0),
              const Style&          style = defaultStyle() );

IDMImage    ( const IBitmapHandle&  bitmap,
              const ISize&          pointerOffset = ISize(0,0),
              const ISize&          stretchSize = ISize(0,0),
              const Style&          style = defaultStyle() );

#ifndef IC_MOTIFWIN_FLAGNOP
IDMImage    ( unsigned long         arrayOfPoints[],
              const unsigned long   numberOfPoints,
              const ISize&          pointerOffset = ISize(0,0),
              const Style&          style = defaultStyle() );
#endif

IDMImage    ( const IDMImage&       image );

virtual
  ~IDMImage ( );

IDMImage
 &operator = ( const IDMImage&      image );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF0(Style, IDMImage);
static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU noStyle,
  IC_IMPORTU ptr,
  IC_IMPORTU bmp,
  IC_IMPORTU polygon,
  IC_IMPORTU stretch,
  IC_IMPORTU transparent,
  IC_IMPORTU closed;

static Style
  defaultStyle    ( );
static void
  setDefaultStyle ( const Style& style );

/*----------------------------- Image Processing -----------------------------*/
IPointerHandle
  pointer           ( ) const;

IBitmapHandle
  bitmap            ( ) const;

ISize
  pointerOffset     ( ) const,
  stretchSize       ( ) const;

Style
  style             ( );

#ifndef IC_MOTIFWIN_FLAGNOP
unsigned long
  numberOfPoints    ( );

unsigned long
 *pointArray        ( );
#endif

IDMImage
 &setPointer        ( const IPointerHandle& pointerImage ),
 &setBitmap         ( const IBitmapHandle&  bitmapImage ),
 &setPointerOffset  ( const ISize&          pointerOffset ),
 &setStretchSize    ( const ISize&          stretchSize ),
 &setStyle          ( const Style&          style );

#ifndef IC_MOTIFWIN_FLAGNOP
IDMImage
 &setNumberOfPoints ( unsigned long         points ),
 &setPointArray     ( unsigned long         arrayOfPoints[],
                      unsigned long         numberOfPoints );
#endif

private:
/*--------------------------------- Private ----------------------------------*/
friend class IDMSourceOperation;

IPointerHandle
  pointerImage;

IBitmapHandle
  bitmapImage;

#ifdef IC_PM
ISystemPointerHandle
  fadeImage;
#endif

unsigned long
 *pPointArray;

ISize
  ptrOffset,
  imageStretchSize;

static Style
  currentDefaultStyle;

Style
  imgStyle;

unsigned long
  points;

#ifdef IC_PM
void
  asPMDragImage ( _DRAGIMAGE* pDragImage,
                   bool    useSystemIcons = false,
                   bool    fadeIcon = false );
#endif

IDMImageData
 *fDMImageData;

}; // IDMImage

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <idmimage.inl>

#endif //_IDMIMAGE_
