// Revision: 78 1.3.1.5 source/ui/drag/idmhndlr.hpp, dragdrop, ioc.v400, 980918 
#ifndef _IDMHNDLR_
#define _IDMHNDLR_
/*******************************************************************************
* FILE NAME: idmhndlr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDMHandler                                                               *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved                    *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IDMSourceHandler;
class IDMTargetHandler;
class IDMRenderer;
class IDMRendererSeq;
class IWindow;
class IEntryField;
class IMultiLineEdit;
class IContainerControl;
class IMenuBar;
class ISubmenu;

class IToolBar;
class IToolBarButton;

class IDMHandlerData;

#ifdef IC_WIN
class IDMDropTargetHandler;
class IDMDragHandler;
#endif

#pragma enum(4)
#pragma pack(push,4)

class IDMHandler : public IHandler {
typedef IHandler
  Inherited;
public:

/*----------------------- Enabling Direct Manipulation -----------------------*/
static void
  enableDragFrom    ( IWindow*           window ),
  enableDragFrom    ( IEntryField*       entryField ),
  enableDragFrom    ( IMultiLineEdit*    mle ),
  enableDragFrom    ( IContainerControl* container ),
//#ifndef IC_MOTIFWIN_FLAGNOP
//  enableDragFrom    ( IMenuBar*          menuBar ),
//  enableDragFrom    ( ISubmenu*          submenu ),
//#endif
  enableDropOn      ( IWindow*           window ),
  enableDropOn      ( IEntryField*       entryField ),
  enableDropOn      ( IMultiLineEdit*    mle ),
  enableDropOn      ( IContainerControl* container ),
  enableDropOn      ( IToolBar*          toolBar ),

  enableDragDropFor ( IWindow*           window ),
  enableDragDropFor ( IEntryField*       entryField ),
  enableDragDropFor ( IMultiLineEdit*    mle ),
  enableDragDropFor ( IContainerControl* container );

static void
  enableDragDropFor ( IToolBarButton*    toolBarButton );

/*----------------------------- Default Handlers -----------------------------*/
static IDMSourceHandler
 &defaultSourceHandler    ( );

static IDMTargetHandler
 &defaultTargetHandler    ( );

#ifdef IC_WIN
static IDMDropTargetHandler
 &defaultDropTargetHandler    ( );
static IDMDragHandler
 &defaultDragHandler      ( );
#endif

static void
  setDefaultSourceHandler ( IDMSourceHandler& source ),
  setDefaultTargetHandler ( IDMTargetHandler& target );


protected:
/*------------------------------- Constructors -------------------------------*/
  IDMHandler  ( );

virtual
  ~IDMHandler ( );

/*------------------------------ Item Providers ------------------------------*/
static void
  setItemProvider ( IEntryField*       entryField ),
  setItemProvider ( IMultiLineEdit*    mle ),
  setItemProvider ( IContainerControl* container );
//#ifndef IC_MOTIFWIN_FLAGNOP
//static void
//  setItemProvider ( ISubmenu*          submenu );
//#endif
static void
  setItemProvider ( IToolBar*          toolBar ),
  setItemProvider ( IToolBarButton*    toolBar );

/*---------------------------- Handler Processing ----------------------------*/
bool
  isContainerControl ( const IWindow* window ) const;

/*-------------------------------- Rendering ---------------------------------*/
virtual unsigned
  numberOfRenderers  ( );

virtual IDMRenderer
 *renderer           ( unsigned           position );

virtual IDMHandler
 &replaceRenderer    ( unsigned           position,
                       const IDMRenderer& replacement ),
 &addRenderer        ( const IDMRenderer& newRenderer ),
 &removeRenderer     ( unsigned           position ),
 &removeRenderer     ( const IDMRenderer& rendererToRemove ),
 &setRenderer        ( const IDMRenderer& newRenderer );

private:
/*--------------------------------- Private ----------------------------------*/

static IDMSourceHandler
 *pSource;
static IDMTargetHandler
 *pTarget;
#ifdef IC_WIN
static IDMDropTargetHandler
 *pDropTarget;
static IDMDragHandler
 *pDragHandler;
#endif

IDMRendererSeq
 *pRendererSeqCl;

IDMRendererSeq
 *rendererCollection ( );

IDMHandlerData
 *fDMHandlerData;
}; // class IDMHandler

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _IDMHNDLR_
