// Revision: 71 1.8.1.3 source/ui/drag/idmevent.hpp, dragdrop, ioc.v400, 980918 
#ifndef _IDMEVENT_
#define _IDMEVENT_
/*******************************************************************************
* FILE NAME: idmevent.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDMEvent                                                                 *
*       IDMSourceBeginEvent                                                    *
*       IDMSourceRenderEvent                                                   *
*         IDMSourcePrepareEvent                                                *
*       IDMSourceEndEvent                                                      *
*       IDMSourceDiscardEvent                                                  *
*       IDMSourcePrintEvent                                                    *
*                                                                              *
*       IDMTargetEvent                                                         *
*         IDMTargetEnterEvent                                                  *
*         IDMTargetLeaveEvent                                                  *
*         IDMTargetDropEvent                                                   *
*       IDMTargetHelpEvent                                                     *
*       IDMTargetEndEvent                                                      *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved                    *
*                                                                              *
*******************************************************************************/
#include <ievent.hpp>
#include <idmitem.hpp>
#include <idmsrcop.hpp>
#include <idmcomm.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

struct _DRAGTRANSFER;
struct _PRINTDEST;

#ifdef IC_PM
struct _DRAGITEM;
#endif

#ifdef IC_MOTIFWIN
class IDragItem;
typedef IDragItem _DRAGITEM;
#endif

class IPoint;
class IString;
class IWindowHandle;
class IPresSpaceHandle;
class IContainerObject;
class IContainerControl;
class IDMSourceOperation;
class IDMEventData;

#pragma enum(4)
#pragma pack(push,4)

class IDMEvent : public IEvent {
typedef IEvent
  Inherited;

public:

/*------------------------------- Constructors -------------------------------*/
  IDMEvent  ( const IEvent& event );

virtual
  ~IDMEvent ( );

private:
/*--------------------------------- Private ----------------------------------*/
  IDMEventData
   *fDMEventData;
}; // IDMEvent


class IDMSourceBeginEvent : public IDMEvent {
typedef IDMEvent
  Inherited;
typedef IDM::Source
  Source;
public:

/*------------------------------- Constructors -------------------------------*/
  IDMSourceBeginEvent  ( const IEvent& event );

virtual
  ~IDMSourceBeginEvent ( );

/*---------------------------- Event Information -----------------------------*/
virtual Source
  source   ( ) const;

virtual IPoint
  position ( ) const;

/*---------------------------- Container Support -----------------------------*/
virtual unsigned long
  containerId ( ) const;

virtual IContainerObject
 *object      ( ) const;

virtual IContainerControl
 *container   ( ) const;

virtual ISize
  offset      ( ) const;

private:
/*--------------------------------- Private ----------------------------------*/

Source
  src;
}; // IDMSourceBeginEvent


class IDMSourceRenderEvent : public IDMEvent {
typedef IDMEvent
  Inherited;
public:

/*------------------------------- Constructors -------------------------------*/
  IDMSourceRenderEvent  ( const IEvent& event );

virtual
  ~IDMSourceRenderEvent ( );


/*-------------------------------- Rendering ---------------------------------*/
virtual IDMItem::Handle
  dragItem              ( ) const;

virtual IWindow
 *alternateWindow       ( ) const,
 *targetWindow          ( ) const;

virtual IWindowHandle
  alternateWindowHandle ( ) const,
  targetWindowHandle    ( ) const;

virtual IString
  selectedMechanism     ( ) const,
  selectedFormat        ( ) const,
  targetName            ( ) const;

virtual unsigned long
  targetInfo            ( ) const;

virtual bool
  canRetry              ( ) const;

virtual IDMSourceRenderEvent
 &setTargetInfo         ( unsigned long         info ),
 &setRetry              ( bool               allowRetry = true ),
 &setCompletion         ( IDM::RenderCompletion code );

virtual IDM::RenderCompletion
  completion            ( ) const;

private:
/*--------------------------------- Private ----------------------------------*/

friend class IDMSourcePrepareEvent;
friend class IDMSourceRenderer;

IDMItem::Handle
  pDMSrcItemHandle;

IString
  strSelMechanism,
  strSelFormat,
  strTgtName;

bool
  bRetry;

IDM::RenderCompletion
  rcCompletion;

#ifdef IC_MOTIFPM
_DRAGTRANSFER
 *pPMDragTransfer;
#endif

IWindowHandle
  tgtWindowHandle;

#ifdef IC_MOTIFPM
_DRAGTRANSFER
 *dragTransfer ( ) const;
#endif
}; // IDMSourceRenderEvent

class IDMSourcePrepareEvent : public IDMSourceRenderEvent {
typedef IDMSourceRenderEvent
  Inherited;
public:

/*------------------------------- Constructors -------------------------------*/
  IDMSourcePrepareEvent  ( const IEvent& event );

virtual
  ~IDMSourcePrepareEvent ( );


/*---------------------------- Alternate Window ------------------------------*/
virtual IWindow
 *alternateWindow          ( ) const;

virtual IWindowHandle
  alternateWindowHandle    ( ) const;

IDMSourcePrepareEvent
 &setAlternateWindowHandle ( const IWindowHandle& window );

/*-------------------------------- Rendering ---------------------------------*/
bool
  targetCanRetry       ( ) const,
  noSourceRendering    ( ) const;

IDMSourcePrepareEvent
 &setTargetCanRetry    ( bool flag ),
 &setNoSourceRendering ( bool flag );

private:
/*--------------------------------- Private ----------------------------------*/

bool
  bTgtCanRetry,
  bNoSrcRendering;
}; // IDMSourcePrepareEvent


class IDMSourceEndEvent : public IDMEvent {
typedef IDMEvent
  Inherited;
public:

/*------------------------------- Constructors -------------------------------*/
  IDMSourceEndEvent  ( const IEvent& event );

virtual
  ~IDMSourceEndEvent ( );

/*-------------------------------- Rendering ---------------------------------*/
virtual IDMItem::Handle
  dragItem            ( ) const;

virtual bool
  wasTargetSuccessful ( ) const;

private:
/*--------------------------------- Private ----------------------------------*/

bool
  bWasTgtSuccessful;

IDMItem::Handle
  pDMSrcItemHandle;
}; // IDMSourceEndEvent


#ifndef IC_MOTIFWIN_FLAGNOP
class IDMSourceDiscardEvent : public IDMEvent {
typedef IDMEvent
  Inherited;
typedef IDM::DiscardIndicator
  DiscardIndicator;
public:

/*------------------------------- Constructors -------------------------------*/
  IDMSourceDiscardEvent  ( const IEvent& event );

virtual
  ~IDMSourceDiscardEvent ( );

/*---------------------------- Event Information -----------------------------*/
IDMSourceOperation::Handle
  sourceOperation    ( ) const;

virtual DiscardIndicator
  whoDiscards        ( ) const;

IDMSourceDiscardEvent
 &setSourceOperation ( const IDMSourceOperation::Handle& operation ),
 &setWhoDiscards     ( DiscardIndicator                  indicator );

private:
/*--------------------------------- Private ----------------------------------*/

IDMSourceOperation::Handle
  pSrcOpH;

DiscardIndicator
  discardInd;
}; // IDMSourceDiscardEvent
#endif // IC_MOTIFWIN_FLAGNOP


#ifndef IC_MOTIFWIN_FLAGNOP
class IDMSourcePrintEvent : public IDMEvent {
typedef IDMEvent
  Inherited;
typedef IDM::PrintIndicator
  PrintIndicator;
public:

/*------------------------------- Constructors -------------------------------*/
  IDMSourcePrintEvent  ( const IEvent& event );

virtual
  ~IDMSourcePrintEvent ( );

/*------------------------------ Print Support -------------------------------*/
IDMSourceOperation::Handle
  sourceOperation    ( ) const;

virtual PrintIndicator
  whoPrints          ( ) const;

IDMSourcePrintEvent
 &setSourceOperation ( const IDMSourceOperation::Handle& operation ),
 &setWhoPrints       ( PrintIndicator                    indicator );

 #ifdef IC_PM
_PRINTDEST
 *printDestination   ( ) const;
#endif

private:
/*--------------------------------- Private ----------------------------------*/

IDMSourceOperation::Handle
  pSrcOpH;

PrintIndicator
  printInd;
}; // IDMSourcePrintEvent
#endif  // IC_MOTIFWIN_FLAGNOP


class IDMTargetEvent : public IDMEvent {
typedef IDMEvent
  Inherited;
public:

/*------------------------------- Constructors -------------------------------*/
  IDMTargetEvent     ( const IEvent& event );

virtual
  ~IDMTargetEvent    ( );

/*------------------------------ Target Emphasis -----------------------------*/
virtual IPresSpaceHandle
  presSpace        ( );

virtual void
  releasePresSpace ( );

private:
/*--------------------------------- Private ----------------------------------*/

IPresSpaceHandle
  hpsEmph;
}; // IDMTargetEvent


class IDMTargetEnterEvent : public IDMTargetEvent {
typedef IDMTargetEvent
  Inherited;
typedef IDM::DropIndicator
  DropIndicator;
public:

/*------------------------------- Constructors -------------------------------*/
  IDMTargetEnterEvent  ( const IEvent& event );

virtual
  ~IDMTargetEnterEvent ( );

/*---------------------------- Event Information -----------------------------*/
virtual DropIndicator
  dropIndicator       ( ) const;

virtual unsigned long
  defaultOperation    ( ) const;

IDMTargetEnterEvent
 &setDropIndicator    ( DropIndicator  indicator ),
 &setDefaultOperation ( unsigned long  operation );

virtual IPoint
  position ( ) const;

/*---------------------------- Container Support -----------------------------*/
virtual bool
  isDragAfter  ( ) const,
  isAboveFirst ( ) const;

virtual unsigned long
  containerId  ( ) const;

virtual IContainerObject
 *object       ( ) const;

virtual IContainerControl
 *container    ( ) const;

private:
/*--------------------------------- Private ----------------------------------*/

DropIndicator
  dropInd;

unsigned long
  op;
}; // IDMTargetEnterEvent


class IDMTargetLeaveEvent : public IDMTargetEvent {
typedef IDMTargetEvent
  Inherited;
public:

/*------------------------------- Constructors -------------------------------*/
  IDMTargetLeaveEvent  ( const IEvent& event );

virtual
  ~IDMTargetLeaveEvent ( );

private:
/*--------------------------------- Private ----------------------------------*/
}; // IDMTargetLeaveEvent


class IDMTargetDropEvent : public IDMTargetEvent {
typedef IDMTargetEvent
  Inherited;
public:

/*------------------------------- Constructors -------------------------------*/
  IDMTargetDropEvent  ( const IEvent& event );

virtual
  ~IDMTargetDropEvent ( );

/*-------------------------- Target Drop Information -------------------------*/
virtual IPoint
  dropPosition    ( ) const;

virtual unsigned long
  targetInfo      ( ) const;

virtual IDMTargetDropEvent
 &setDropPosition ( const IPoint& position ),
 &setTargetInfo   ( unsigned long info );

/*----------------------------- Container Support ----------------------------*/
virtual unsigned long
  containerId ( ) const;

virtual IContainerObject
 *object      ( ) const;

virtual IContainerControl
 *container   ( ) const;

private:
/*--------------------------------- Private ----------------------------------*/

IPoint
  pos;

unsigned long
  ulTgtInfo;
}; // IDMTargetDropEvent


#ifndef IC_WIN_FLAGNOP
class IDMTargetHelpEvent : public IDMEvent {
typedef IDMEvent
  Inherited;
public:

/*------------------------------- Constructors -------------------------------*/
  IDMTargetHelpEvent  ( const IEvent& event );

virtual
  ~IDMTargetHelpEvent ( );


/*---------------------------- Event Information -----------------------------*/
virtual unsigned long
  operation ( ) const;

private:
/*--------------------------------- Private ----------------------------------*/
}; // IDMTargetHelpEvent
#endif  // IC_WIN_FLAGNOP


#ifndef IC_MOTIFWIN_FLAGNOP
class IDMTargetEndEvent : public IDMEvent {
typedef IDMEvent
  Inherited;
public:

/*------------------------------- Constructors -------------------------------*/
  IDMTargetEndEvent  ( const IEvent& event );

virtual
  ~IDMTargetEndEvent ( );

/*------------------------------ Alternate Window ----------------------------*/
virtual IWindow
 *alternateWindow       ( ) const;

virtual IWindowHandle
  alternateWindowHandle ( ) const;

/*---------------------------------- Rendering -------------------------------*/
bool
  renderingFailed ( ) const,
  targetCanRetry  ( ) const;

virtual IDMItem::Handle
  dragItem              ( ) const;

virtual unsigned long
  targetInfo            ( ) const;

private:
/*--------------------------------- Private ----------------------------------*/

IDMItem::Handle
  targetItemFromPM ( _DRAGITEM *pDragItem );

IDMItem::Handle
  pDMTgtItemHandle;

unsigned long
  usCompletion;

friend class IDMTargetRenderer;

_DRAGTRANSFER
 *pPMDragTransfer;

_DRAGTRANSFER
  *dragTransfer ( ) const;
}; // IDMTargetEndEvent
#endif  // IC_MOTIFWIN_FLAGNOP

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <idmevent.inl>

#endif //_IDMEVENT_
