// Revision: 69 1.3.1.3 source/ui/drag/idmefit.hpp, dragdrop, ioc.v400, 980918 
#ifndef _IDMEFIT_
#define _IDMEFIT_
/*******************************************************************************
* FILE NAME: idmefit.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDMEFItem                                                                *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved                    *
*                                                                              *
*******************************************************************************/
#include <idmitem.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IDMSourceOperation;
class IDMEFItemData;

#pragma enum(4)
#pragma pack(push,4)

class IDMEFItem : public IDMItem {
typedef IDMItem
  Inherited;
public:

/*------------------------------- Constructors -------------------------------*/
  IDMEFItem  ( IDMSourceOperation*    sourceOperation );

  IDMEFItem  ( const IDMItem::Handle& dragItem );

virtual
  ~IDMEFItem ( );


/*------------------------------ Source Items --------------------------------*/
static bool
  generateSourceItems ( IDMSourceOperation* sourceOperation );

virtual void
 *object              ( ) const;

/*------------------------------ Drop Processing -----------------------------*/
virtual bool
  sourceEnd  ( IDMSourceEndEvent&  event ),
  targetDrop ( IDMTargetDropEvent& event );

private:
/*--------------------------------- Private ----------------------------------*/

IDMEFItemData
 *fDMEFItemData;

}; // IDMEFItem

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _IDMEFIT_
