// Revision: 48 1.3.1.3 source/ui/drag/idmcnrit.hpp, dragdrop, ioc.v400, 980918 
#ifndef _IDMCNRIT_
#define _IDMCNRIT_
/*******************************************************************************
* FILE NAME: idmcnrit.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDMCnrItem                                                               *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved                    *
*                                                                              *
*******************************************************************************/
#include <idmitem.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IContainerControl;
class IContainerObject;
class IDMCnrItemData;

#pragma enum(4)
#pragma pack(push,4)

class IDMCnrItem : public IDMItem  {
typedef IDMItem
  Inherited;
public:

/*------------------------------- Constructors -------------------------------*/
  IDMCnrItem  ( IContainerControl*     container,
                IContainerObject*      object,
                IDMSourceOperation*    sourceOperation,
                const ISize&           imageOffset);

  IDMCnrItem  ( const IDMItem::Handle& dragItem );

virtual
  ~IDMCnrItem ( );


/*------------------------------ Source Items --------------------------------*/
static bool
  generateSourceItems ( IDMSourceOperation* sourceOperation );

virtual unsigned long
  containerId         ( ) const;

virtual IContainerControl
 *sourceContainer     ( ) const;

/*------------------------------ Drop Processing -----------------------------*/
virtual bool
  targetDrop ( IDMTargetDropEvent& event );

private:
/*--------------------------------- Private ----------------------------------*/

IContainerControl
 *pContainerCtl;

IDMCnrItemData
 *fDMCnrItemData;

}; // IDMCnrItem

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _IDMCNRIT_
