#ifndef _IDLLMOD_
#define _IDLLMOD_
/*******************************************************************************
* FILE NAME: idllmod.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declarations of the classes:                                               *
*     IDLLModule                                                               *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
// Revision: 69  1.4.1.5  source/core/base/idllmod.hpp, appsupport, ioc.v400, 980918  

#include <ibase.hpp>
#include <ibasepl.hpp>
#include <ibhandle.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IDLLModulePrivateData;
class IRefCountedDLLImp;

#pragma enum(4)
#pragma pack(push,4)

class IC_EXPORTB IDLLModule
{
public:
enum ESearchLocation { 
   kOSDefaultSearch, 
   kNLSPathSearch 
};
/*------------------------------- Constructors -------------------------------*/
  IDLLModule   ( const char*      fileName,
                 ESearchLocation  searchOrder = kOSDefaultSearch );

  IDLLModule   ( const IDLLModule& dllLibrary );


  IDLLModule   ( const IModuleHandle& moduleHandle );


 ~IDLLModule   ( );

IDLLModule
 &operator=    ( const IDLLModule& dllLibrary );

/*-------------------------- Opening and Closing -----------------------------*/
IDLLModule
 &open                ( ),
 &close               ( );

/*----------------------- Procedure Address Loading --------------------------*/
void
 *procAddress       ( const char*   procedureName ) const;

void
 *procAddress       ( unsigned long procedureOrdinal ) const;



bool
  isEntryPoint32Bit ( const char*   procedureName ) const,
  isEntryPoint32Bit ( unsigned long procedureOrdinal ) const;


/*--------------------- Dynamic Link Library Information ---------------------*/
bool
  isOpen            ( ) const;

IString
  fileName          ( ) const;

IModuleHandle
  handle            ( ) const;

private:
/*-------------------------------- Private -----------------------------------*/
static unsigned long
  addRef          ( const IModuleHandle& moduleHandle ),
  removeRef       ( const IModuleHandle& moduleHandle );

IDLLModulePrivateData
 *fPrivateData;
IRefCountedDLLImp
 *fDLLImp;
};

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _IDLLMOD_
