// Revision: 09 1.5.1.4 source/ui/baseapp/idievt.hpp, genhdr, ioc.v400, 980918 
#ifndef _IDIEVT_
#define _IDIEVT_
/*******************************************************************************
* FILE NAME: idievt.hpp                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDrawItemEvent                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <ictlevt.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IPresSpaceHandle;
class IRectangle;

#pragma enum(4)
#pragma pack(push,4)

class IDrawItemEvent : public IControlEvent {
typedef IControlEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IDrawItemEvent ( const IEvent& event );

virtual
 ~IDrawItemEvent ( );

/*----------------------------- Item Information -----------------------------*/
virtual IPresSpaceHandle
  itemPresSpaceHandle ( ) const;

virtual unsigned long
  itemId              ( ) const;

virtual IRectangle
  itemRect            ( ) const;

protected:
/*------------------------------ Implementation ------------------------------*/
void
 *ownerItemData ( ) const;

private:
/*--------------------------------- Private ----------------------------------*/
void
 *pvOwnerItem;
}; // IDrawItemEvent

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <idievt.inl>

#endif /* _IDIEVT_ */
