#ifndef _IDEQUE2_
  #define _IDEQUE2_
/*******************************************************************************
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/

#include <ibase.hpp>

#ifdef IC_USE_STL
  #include <iqueue2.h>

  template <class Element, class Imp>
    class ITImpDeque : public ITImpQueue<Element,  Imp>
  {
  public:
    ITImpDeque( unsigned long numberOfElements = 100);
    ~ITImpDeque();
  };

  template <class Element>
    class IDeque : public ITImpDeque<Element,  Element>
  {
    public:
    IDeque( unsigned long numberOfElements = 100);
   ~IDeque();
  };

  #ifdef IC_USE_STL_VPTR
    template <class Element>
      class IVPtrDeque : public ITImpDeque<Element,  void*>
    {
      public:
      IVPtrDeque( unsigned long numberOfElements = 100);
     ~IVPtrDeque();
    };
  #else
    #define IVPtrDeque IDeque
  #endif

  #ifndef __TEMPINC__
    #include <ideque2.c>
  #endif

#else
  #include <ideque.h>
  #define IVPtrDeque IDeque
#endif

#endif // _IDEQUE2_

