// Revision: 30 1.4.1.3 source/dde/iddetsrv.hpp, dde, ioc.v400, 980918 
#ifndef _IDDETSRV_
#define _IDDETSRV_
/*******************************************************************************
* FILE NAME: iddetsrv.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDDETopicServer                                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved                    *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>

#ifdef IC_PMWIN

#include <istring.hpp>
#include <ihandler.hpp>
#include <ihandle.hpp>
#include <iddeevt.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IObjectWindow;
class IFrameWindow;
class IThread;
class IDDEServerConversationSet;
class IDDEServerHotLinkItemSet;
class IDDEFormatSet;
class IDDETopicServerData;

#ifdef IC_WIN
  class IDDEItemAtomSet;
#endif

#pragma enum(4)
#pragma pack(push,4)


class IDDETopicServer : protected IHandler {
typedef IHandler
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IDDETopicServer ( const char*   applicationName,
                    const char*   supportedTopic,
                    IFrameWindow* owner = 0,
                    bool       useEventThread = true );

virtual
 ~IDDETopicServer ( );

/*------------------- Conversation Initiation/Termination --------------------*/
virtual IDDETopicServer
 &beginConversation ( const IWindowHandle& clientHandle ),
 &endConversation   ( unsigned long conversationId );

/*----------------------------- Hot Link Updates -----------------------------*/
unsigned long
  hotLinkUpdate ( const char* item );

/*---------------------------- Server Attributes -----------------------------*/
unsigned long
  conversationCount ( ) const,
  hotLinkCount      ( ) const;

IString
  application ( ) const,
  topic       ( ) const;

IWindowHandle
  serverHandle ( ) const;

protected:
/*----------------------------- Event Processing -----------------------------*/
virtual bool
  requestData        ( unsigned long           conversationId,
                       IDDERequestDataEvent&   event ) = 0,
  pokeData           ( unsigned long           conversationId,
                       IDDEPokeEvent&          event ),
  beginHotLink       ( unsigned long           conversationId,
                       IDDEServerHotLinkEvent& event ),
  executeCommands    ( unsigned long           conversationId,
                       IDDEExecuteEvent&       event ),
  acceptConversation ( unsigned long           conversationId,
                       IDDEBeginEvent&         event );

virtual void
  requestHotLinkData  ( IDDERequestDataEvent&       event ),
  hotLinkEnded        ( unsigned long               conversationId,
                        IDDEEvent&                  event ),
  acknowledged        ( unsigned long               conversationId,
                        IDDEServerAcknowledgeEvent& event ),
  conversationEnded   ( unsigned long               conversationId,
                        IDDEEndEvent&               event );

/*--------------------- Event Processing Implementation ----------------------*/
virtual bool
  dispatchHandlerEvent ( IEvent& event );

virtual void
  handleAck       ( const IEvent& ackEvent ),
  handleAdvise    ( const IEvent& adviseEvent ),
  handleExecute   ( const IEvent& executeEvent ),
  handleInitiate  ( const IEvent& initiateEvent ),
  handlePoke      ( const IEvent& pokeEvent ),
  handleRequest   ( const IEvent& requestEvent ),
  handleTerminate ( const IEvent& terminateEvent ),
  handleUnadvise  ( const IEvent& unadviseEvent );

virtual bool
  removeLink ( IString       item,
               IString       format,
               unsigned long conversationId );

private:
/*------------------------------ Hidden Members ------------------------------*/
  IDDETopicServer ( const IDDETopicServer& server );
IDDETopicServer
 &operator=( const IDDETopicServer& server );

/*--------------------------------- Private ----------------------------------*/
IDDEServerHotLinkItemSet
 &hotLinkItems ( ) const;
IDDEServerConversationSet
 &closedConversations ( ) const,
 &conversations       ( ) const;
IDDEFormatSet
 &formats ( ) const;

#ifdef IC_WIN
IDDEItemAtomSet
 &itemAtoms ( ) const;
#endif

unsigned long
  queueHandle ( ) const;

void
  dispatchEventFromQueue ( );

#ifdef IC_PM
void
 *buildDDEStruct ( const char*    itemName,
                   const char*    dataFormat,
                   unsigned short status,
                   const void*    xferData,
                   unsigned long  dataLength );
#endif
#ifdef IC_WIN
void
 *buildDDEStruct ( int            ddeStructType,
                   const char*    dataFormat,
                   unsigned short status,
                   const void*    xferData,
                   unsigned long  dataLength );
#endif

unsigned long
 ulClQHandle,
 ulClSemaphore;
IThread
 *pThreadCl;
bool
  fClHdrActive,
  fClPostMsgFail;
IWindowHandle
  wndhClServer;
IObjectWindow
 *pwndClServer;
IString
  strClTopic,
  strClApplication;
IDDEServerConversationSet
 *pConvSetCl;
IDDEServerHotLinkItemSet
 *pHLItemSetCl;
IDDEServerConversationSet
 *pClsdConvSetCl;
IDDEFormatSet
 *pFormatSetCl;

#ifdef IC_WIN
IDDEItemAtomSet
 *pItemAtomSetCl;

void
 *hReadPipe,
 *hWritePipe,
 *hFinish;
#endif

IDDETopicServerData
 *fDDETopicServerData;
}; // IDDETopicServer

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <iddetsrv.inl>

#endif /* IC_PMWIN  */

#endif /* _IDDETSRV_ */
