// Revision: 21 1.6.1.5 source/dde/iddecset.hpp, dde, ioc.v400, 980918 
#ifndef _IDDECSET_
#define _IDDECSET_
/*******************************************************************************
* FILE NAME: iddecset.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDDEActiveServer                                                         *
*     IDDEActiveServerSet                                                      *
*     IDDEClientHotLinkSet                                                     *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved                    *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>

#ifdef IC_PMWIN

#include <istring.hpp>
#include <iddeevt.hpp>
#include <ireslock.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IDDEClientHotLinkSetImp;
class IDDEActiveServerSetImp;

#pragma enum(4)
#pragma pack(push,4)

class IDDEActiveServer {
public:
/*------------------------------- Constructors -------------------------------*/
  IDDEActiveServer ( const char* applicationName,
                     const char* topicName,
                     bool     caseSensitive );

 ~IDDEActiveServer ( );

/*---------------------------- Server Attributes -----------------------------*/
IString
  application ( ) const,
  topic       ( ) const;

bool
  isCaseSensitive ( ) const;

private:
/*--------------------------------- Private ----------------------------------*/
IString
  strClApplication,
  strClTopic;
bool
  fClCaseSensitive;

}; // IDDEActiveServer

class IDDEActiveServerSet
{
public:

/*------------------------ Constructors --------------------------------------*/
  IDDEActiveServerSet ( );


 ~IDDEActiveServerSet ( );


  class Cursor
  {
  public:
    Cursor (const IDDEActiveServerSet& serverSet);

   ~Cursor ( );

    bool
      setToFirst    ( ),
      setToNext     ( ),
      isValid       ( ) const;

    void
      invalidate ( );

    IDDEActiveServer* const
      element    ( ) const;

private:
      const IDDEActiveServerSetImp
       *fServerSetImp;
      void
       *fServerCursorImp;

      Cursor ( const Cursor& cursor);
      Cursor& operator=(const Cursor& cursor);

      friend class IDDEActiveServerSet;
  }; // Cursor


bool
  add              ( IDDEActiveServer* const& activeServer);


IDDEActiveServer*
  elementAt        ( const Cursor& cursor) const;

bool
  isEmpty          ( ) const;

unsigned long
  numberOfElements ( ) const,
  removeAll        ( );


unsigned long
  removeAll ( bool (*predicateFunction)(IDDEActiveServer* const&, void*),
              void* data=0);

void
  removeAt         ( Cursor& cursor),
  replaceAt        ( const Cursor& cursor,
                     IDDEActiveServer* const& activeServer);


bool
  allElementsDo   ( bool (*function) (IDDEActiveServer* &, void*),
                    void* additionalArgument = 0);

private:
friend class Cursor;
IDDEActiveServerSetImp
 *fServerSetImp;

IDDEActiveServerSet(const IDDEActiveServerSet&);
IDDEActiveServerSet& operator=(const IDDEActiveServerSet&);
}; // IDDEActiveServerSet

class IDDEClientHotLinkSet {
public:
/*------------------------------- Constructors -------------------------------*/
  IDDEClientHotLinkSet ( );


 ~IDDEClientHotLinkSet ( );


   class Cursor
   {
   public:
     Cursor   ( const IDDEClientHotLinkSet& hotLinkSet);
    ~Cursor ( );

     bool
       setToFirst    ( ),
       setToNext     ( ),
       isValid       ( ) const;

     void
       invalidate    ( );

     IDDEClientHotLinkEvent* const
       element       ( ) const;

   private:      
       const IDDEClientHotLinkSetImp
        *fClientSetImp;
       void
        *fClientCursorImp;

       Cursor   ( const Cursor& cursor);
       Cursor& operator=( const Cursor& cursor);

      friend class IDDEClientHotLinkSet;
   }; // Cursor


bool
  add       ( IDDEClientHotLinkEvent* const& hotLinkEvent);


IDDEClientHotLinkEvent*
  elementAt   ( const Cursor& cursor) const;

bool
  isEmpty     ( ) const;

unsigned long
  numberOfElements ( ) const,
  removeAll        ( ),
  removeAll        ( bool (*predicateFunction)(IDDEClientHotLinkEvent* const&,
                                               void*),
                     void* data=0);

void
  removeAt    ( Cursor&                   cursor),
  replaceAt   ( const Cursor&             cursor,
                IDDEClientHotLinkEvent* const& hotLinkEvent);

bool
  allElementsDo   ( bool (*function) (IDDEClientHotLinkEvent* &, void*),
                    void* additionalArgument = 0);

private:
/*--------------------------------- Private ----------------------------------*/
friend class IDDEClientConversation;
friend class Cursor;

IPrivateResource
 &semaphor ( );

IPrivateResource
  priResCl;

IDDEClientHotLinkSetImp
    *fClientSetImp;

IDDEClientHotLinkSet(const IDDEClientHotLinkSet&);
IDDEClientHotLinkSet& operator=(const IDDEClientHotLinkSet&);
}; // IDDEClientHotLinkSet

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <iddecset.inl>

#endif /* IC_PMWIN  */

#endif // _IDDECSET_
