// Revision: 17 1.4.1.3 source/dde/iddeccnv.hpp, dde, ioc.v400, 980918 
#ifndef _IDDECCNV_
#define _IDDECCNV_
/*******************************************************************************
* FILE NAME: iddeccnv.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDDEClientConversation                                                   *
*                                                                              *
*   NOTE:  IDDEActiveServer, IDDEActiveServerSet and IDDEClientHotLinkSet      *
*          are defined in iddecset.hpp.                                        *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved                    *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>

#ifdef IC_PMWIN

#include <istring.hpp>
#include <ihandle.hpp>
#include <ihandler.hpp>
#include <iddeevt.hpp>
#include <iddecomm.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IObjectWindow;
class IDDEClosedConversationSet;
class IDDETransactionQueue;
class IDDEActiveServerSet;
class IDDEClientHotLinkSet;
class IDDEFormatSet;
class IThread;
class IDDEClientConversationData;

#ifdef IC_WIN
  class IDDEItemAtomSet;
#endif

#pragma enum(4)
#pragma pack(push,4)

class IDDEClientConversation : protected IHandler {
typedef IHandler
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IDDEClientConversation ( bool     useEventThread = true );
  IDDEClientConversation ( const char* applicationName,
                           const char* topicName,
                           bool     useEventThread = true );

virtual
 ~IDDEClientConversation ( );

/*------------------- Conversation Initiation/Termination --------------------*/
virtual bool
  begin ( const char* applicationName,
          const char* topicName );

virtual IDDEClientConversation
 &begin ( const IWindowHandle& serverHandle ),
 &end   ( );

/*------------------------------- Transactions -------------------------------*/
virtual IDDEClientConversation
 &requestData     ( const char*   item,
                    IDDE::Format  format = IDDE::textFormat ),
 &pokeData        ( const char*   item,
                    const void*   data,
                    unsigned long dataLength,
                    IDDE::Format  format = IDDE::textFormat ),
 &beginHotLink    ( const char*   item,
                    IDDE::Format  format = IDDE::textFormat,
                    bool       sendData = true,
                    bool       pacing = false ),
 &endHotLink      ( const char*   item,
                    IDDE::Format  format = IDDE::textFormat ),
 &endHotLinks     ( const char*   item = 0),
 &executeCommands ( const void*   commands,
                    unsigned long commandLength );

/*------------------------- Conversation Attributes ---------------------------*/
IString
  application ( ) const,
  topic       ( ) const;

bool
  isCaseSensitive ( ) const,
  inConversation  ( ) const;

unsigned long
  outstandingTransactionCount ( ) const;

IWindowHandle
  clientHandle ( ) const;

/*--------------------------- Hot Link Information ---------------------------*/
IDDEClientConversation
 &hotLinks ( IDDEClientHotLinkSet& hotLinkSet );

unsigned long
  hotLinkCount ( ) const;

/*-------------------------------- Broadcasts --------------------------------*/
virtual IDDEClientConversation
 &supportedTopics        ( IDDEActiveServerSet& activeServerSet,
                           const char* applicationName = 0 ),
 &supportingApplications ( IDDEActiveServerSet& activeServerSet,
                           const char* topicName );

protected:
/*----------------------------- Event Processing -----------------------------*/
virtual bool
  data           ( IDDEDataEvent&          event) = 0,
  hotLinkInform  ( IDDEClientHotLinkEvent& event);

virtual void
  acknowledged        ( IDDEClientAcknowledgeEvent&  event ),
  executeAcknowledged ( IDDEAcknowledgeExecuteEvent& event ),
  pokeAcknowledged    ( IDDEAcknowledgePokeEvent&    event ),
  conversationEnded   ( IDDEClientEndEvent&          event );

/*--------------------- Event Processing Implementation ----------------------*/
virtual bool
  dispatchHandlerEvent ( IEvent& event );

virtual void
  handleAck         ( const IEvent& ackEvent ),
  handleData        ( const IEvent& dataEvent ),
  handleInitiateAck ( const IEvent& initiateAckEvent ),
  handleTerminate   ( const IEvent& terminateEvent );

/*----------------------- Miscellaneous Implementation -----------------------*/
virtual void
  endAllHotLinks ( const char* item ),
  endAllHotLinks ( );

virtual bool
  findTransaction ( const IEvent& event,
                    bool       removeMatch = false );

private:
/*------------------------------ Hidden Members ------------------------------*/
  IDDEClientConversation  ( const IDDEClientConversation& conversation );
IDDEClientConversation
 &operator=               ( const IDDEClientConversation& conversation );

/*--------------------------------- Private ----------------------------------*/
IWindowHandle
  serverHandle ( ) const;
IDDEClientHotLinkSet
 &hotLinksForUpdate ( ) const;
IDDEClosedConversationSet
 &closedConversations ( ) const;
IDDETransactionQueue
 &transactions ( ) const;
IDDEFormatSet
 &formats ( ) const;

#ifdef IC_WIN
IDDEItemAtomSet
 &itemAtoms ( ) const;
#endif

unsigned long
  queueHandle ( ) const;
void
  dispatchEventFromQueue ( );

#ifdef IC_PM
void
 *buildDDEStruct ( const char*    itemName,
                   const char*    dataFormat,
                   unsigned short status,
                   const void*    xferData,
                   unsigned long  dataLength );
#endif   /* IC_PM */
#ifdef IC_WIN
void
 *buildDDEStruct ( int            ddeStructType,
                   const char*    dataFormat,
                   unsigned short status,
                   const void*    xferData,
                   unsigned long  dataLength );
#endif   /* IC_WIN */

unsigned long
 ulClQHandle,
 ulClSemaphore;
IThread
 *pThreadCl;
IWindowHandle
  wndhClServer,
  wndhClClient;
IObjectWindow
 *pwndClClient;
bool
  fClBrdcstInPrgrs,
  fClHdrActive,
  fClPostMsgFail,
  fClCaseSensitive;
IString
  strClTopic,
  strClApplication;
IDDEActiveServerSet
 *pActServSetCl;
IDDEClosedConversationSet
 *pClsdConvSetCl;
IDDEClientHotLinkSet
 *pHLSetCl;
IDDETransactionQueue
 *pTransQCl;
IDDEFormatSet
 *pFormatSetCl;

#ifdef IC_WIN
IDDEItemAtomSet
 *pItemAtomSetCl;

void
 *hReadPipe,
 *hWritePipe,
 *hFinish;
#endif

IDDEClientConversationData
 *fDDEClientConversationData;
}; // IDDEClientConversation

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <iddeccnv.inl>

#endif /* IC_PMWIN  */

#endif /* _IDDECCNV_ */
