// ----------------------------------------------------------------------------
//  FILE: idatstrm.hpp
//
//  Defines the IDataStream class.
//
//  COPYRIGHT
//    IBM Open Class Library
//    (C) Copyright International Business Machines Corporation,  1997
//    Licensed Material - Program-Property of IBM - All Rights Reserved.
//
// Revision: 44 1.16.1.4 source/core/streams/idatstrm.hpp, oss, ioc.v400, 980918 
// ----------------------------------------------------------------------------

#ifndef _IDATSTRM_
#define _IDATSTRM_

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

//
// external class declarations.
//
class IMStreamable;
class ITypeRepresentation;
class IStreamFinder;
class IStreamFactory;
class IStreamIO;

#pragma enum(4)
#pragma pack(push,4)

class IDataStream
{
public:
    ~IDataStream();

    enum EStreamEncoding
    {
        kInteroperableBinary,
        kRawBinary,
        kDebug
    };

    static IDataStream* createMemoryStream(int encoding = kInteroperableBinary);

    IStreamIO* streamIO() const;

    void writeByte(char source);
    void writeShort(short source);
    void writeLong(long source);
    void writeFloat(float source);
    void writeDouble(double source);

    char readByte();
    short readShort();
    long readLong();
    float readFloat();
    double readDouble();

    void writeBytes(const char* data, unsigned long howMany);
    void readBytes(char* data, unsigned long howMany);
    void writeShorts(const short* data, unsigned long howMany);
    void readShorts(short* data, unsigned long howMany);
    void writeLongs(const long* data, unsigned long howMany);
    void readLongs(long* data, unsigned long howMany);
    void writeFloats(const float* data, unsigned long howMany);
    void readFloats(float* data, unsigned long howMany);
    void writeDoubles(const double* data, unsigned long howMany);
    void readDoubles(double* data, unsigned long howMany);

    void reset();

    void flush();

private:
    IDataStream();
    IDataStream(const IDataStream& other);

    friend class IStreamFactory;
    IDataStream(IStreamIO* streamIO);

private:
    IStreamIO*  fStreamIO;
};

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <idatstrm.inl>
#include <igstream.hpp>

#endif
