// Revision: 34 1.7.1.7 source/ui/extapp/icustbut.hpp, toolbar, ioc.v400, 980918 
#ifndef _ICUSTBUT_
#define _ICUSTBUT_
/*******************************************************************************
* FILE NAME: icustbut.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ICustomButton                                                            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <ibutton.hpp>
#include <irect.hpp>
#include <icolor.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class ISize;
class ICustomButtonData;

#pragma enum(4)
#pragma pack(push,4)

class ICustomButton : public IButton {
typedef IButton
  Inherited;
public:
class Style;
/*------------------------------- Constructors -------------------------------*/
  ICustomButton  ( unsigned long     id,
                   IWindow*          parent,
                   IWindow*          owner,
                   const IRectangle& initial = IRectangle(),
                   const Style&      style = defaultStyle() );

  ICustomButton ( const IWindowHandle& handle );

virtual
  ~ICustomButton ( );

#ifdef IC_MOTIF
/*-------------------------------- Accessors ---------------------------------*/
virtual ICustomButton
 &setText                ( const char* text ),
 &setText                ( const IResourceId& text );

virtual IString
  text                   ( ) const;

/*------------------------------ Font Functions ------------------------------*/
virtual ICustomButton
 &setFont       ( const IFont& font );

virtual ICustomButton
 &resetFont     ( );

virtual IFont
  font          ( ) const;

ISize
  characterSize ( ) const;

/*-------------------------------- Attributes --------------------------------*/
virtual ICustomButton
 &enable                    ( bool           enableWindow = true ),
 &disable                   ( );
#endif

/*-------------------------------- Style -------------------------------------*/
INESTEDBITFLAGCLASSDEF3(Style, ICustomButton, IWindow, IControl, IButton);

static const Style
  IC_IMPORTU latchable,
  IC_IMPORTU autoLatch,
  IC_IMPORTU classDefaultStyle;

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      bool         extendedOnly = false ) const;

/*------------------------------ Latch Support -------------------------------*/
virtual ICustomButton
 &enableLatching   ( bool enable = true ),
 &disableLatching  ( ),
 &enableAutoLatch  ( bool enable = true ),
 &disableAutoLatch ( );

virtual bool
  isLatchingEnabled  ( ) const,
  isAutoLatchEnabled ( ) const;

virtual ICustomButton
 &latch        ( bool latched = true,
                 bool refresh = true ),
 &unlatch      ( );

virtual bool
  isLatched    ( ) const;

/*-------------------------------- Colors ------------------------------------*/
virtual IColor
  backgroundColor                  ( ) const,
  latchedForegroundColor           ( ) const,
  latchedBackgroundColor           ( ) const;

virtual ICustomButton
  &setLatchedForegroundColor       ( const IColor& color ),
  &setLatchedBackgroundColor       ( const IColor& color,
                                     bool       halftone = true ),
  &resetLatchedForegroundColor     ( ),
  &resetLatchedBackgroundColor     ( );

#ifdef IC_WIN
virtual ICustomButton
 &setBackgroundColor              ( const IColor& color ),
 &resetBackgroundColor            ( );
#endif

virtual bool
  isLatchedBackgroundColorHalftone ( ) const;

/*------------------------- Notification Members -----------------------------*/
static INotificationId const
  IC_IMPORTU latchId;

/*------------------------------- User Data ----------------------------------*/
unsigned long
  userData ( ) const;

ICustomButton
  &setUserData ( unsigned long data );

/*-------------------------- Canvas Support ----------------------------------*/
virtual ICustomButton
  &setLayoutDistorted ( unsigned long layoutAttributeOn,
                        unsigned long layoutAttributeOff );

protected:
/*----------------------------- Layout Support -------------------------------*/
virtual ISize
  calcMinimumSize ( ) const;

/*---------------------- Event Handling Implementation -----------------------*/
#ifdef IC_MOTIF
virtual bool
  passEventToOwner     ( IEvent &event );
#endif

/*------------------------- Default Draw Handler -----------------------------*/
ICustomButton
  &addDefaultDrawHandler    ( ),
  &removeDefaultDrawHandler ( );


/*------------------------- Constructors -------------------------------------*/
  ICustomButton ( );

/*---------------------------- Color Functions -------------------------------*/
#ifdef IC_WIN
virtual ICustomButton
 &setColor         ( unsigned long colorArea,
                     const IColor& color );
#endif

private:
/*--------------------------------- Private ----------------------------------*/
/*--------------------------- Hidden Members ---------------------------------*/
  ICustomButton             ( const ICustomButton& );
  ICustomButton& operator = ( const ICustomButton& );
static Style
  fgCurrentDefaultStyle;
ICustomButtonData
 *fCustomButtonData;
void
  checkAutoLatch ( );

#ifdef IC_MOTIF
friend void _System iCustomButtonMotifCallback ( _WidgetRec *w,
                                                 void       *client_data,
                                                 void       *call_data );
#endif
};

INESTEDBITFLAGCLASSFUNCS(Style, ICustomButton);

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _ICUSTBUT_ */
