// Revision: 31 1.4.1.3 source/ui/extapp/icustbhd.hpp, toolbar, ioc.v400, 980918 
#ifndef _ICUSTBHD_
#define _ICUSTBHD_
/*******************************************************************************
* FILE NAME: icustbhd.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ICustomButtonDrawHandler                                                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>
#include <icustbev.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push,4)

class ICustomButtonDrawHandler : public IHandler {
typedef IHandler
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
   ICustomButtonDrawHandler();

virtual
  ~ICustomButtonDrawHandler();

protected:
/*---------------------------- Event Dispatching -----------------------------*/
virtual bool
  dispatchHandlerEvent(IEvent& event);

/*---------------------------- Event Processing ------------------------------*/
virtual bool
  drawButton           ( ICustomButtonDrawEvent& event );

virtual void
  drawBorder           ( ICustomButtonDrawEvent& event,
                         ISize                   margin = ISize() ),
  drawBackground       ( ICustomButtonDrawEvent& event ),
  drawForeground       ( ICustomButtonDrawEvent& event ),
  drawDisabledEmphasis ( ICustomButtonDrawEvent& event );

private:
/*--------------------------------- Private ----------------------------------*/
};

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* ICUSTBHD */
