// Revision: 29 1.10.1.6 source/ui/extapp/icustbev.hpp, toolbar, ioc.v400, 980918 
#ifndef _ICUSTBEV_
#define _ICUSTBEV_
/*******************************************************************************
* FILE NAME: icustbev.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*    Declaration of the classes:                                               *
*      ICustomButtonDrawEvent                                                  *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>
#include <ictlevt.hpp>
#include <igrport.hpp>
#include <iimage.hpp>
#include <irect.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class ICustomButton;
class IGraphicContext;
class IVBase;

#pragma enum(4)
#pragma pack(push,4)

class ICustomButtonDrawEvent : public IControlEvent {
typedef IControlEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  ICustomButtonDrawEvent (const IEvent&                 event);
  ICustomButtonDrawEvent (const ICustomButtonDrawEvent& event);
  ICustomButtonDrawEvent (const IEvent&                 event,
                          const ISize&                  size,
                          const bool                    trueColor = false);

virtual
 ~ICustomButtonDrawEvent ( );

/*------------------------------ Drawing -------------------------------------*/
IGrafPort
  &grafPort ( ) const;
#if ( IC_OBSOLETE <= IC_OBSOLETE_3 )
IGraphicContext
  &graphicContext    ( ) const;
#endif // IC_OBSOLETE

enum ButtonState {
  buttonUp,
  buttonDown,
  buttonLatched
};

ButtonState
  buttonState () const;

bool
  drawUp      () const,
  drawDown    () const,
  drawLatched () const;

IRectangle
  drawingArea () const;

virtual ICustomButtonDrawEvent
  &setDrawingArea ( const IRectangle& rectangle );

bool
  isButtonEnabled () const;

/*----------------------------- Custom Button --------------------------------*/
virtual ICustomButton
 *customButton () const;


private:
/*--------------------------------- Private ----------------------------------*/
ICustomButtonDrawEvent (const IEvent& event,
                        const ISize&  size,
                        IGrafPort*    grafPort);
  ICustomButtonDrawEvent& operator = ( const ICustomButtonDrawEvent& );
IRectangle
  fRectangle;
friend class IToolBarButtonData;  //Needs access to fImage
friend class ICustomButtonDrawHandler;  //Uses grafport ctor

IImage
 *fImage;
IGrafPort
 *fGrafPort;
#if ( IC_OBSOLETE <= IC_OBSOLETE_3 )
IVBase
  *fGraphicContext;
#endif // IC_OBSOLETE
bool
  fManageGrafPort;
};

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _ICUSTBEV_ */
